/*
 * $Id: ColumnEntity.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.dbpowder.sql;

import java.sql.ResultSetMetaData;
import org.apache.commons.lang.StringUtils;
import org.tadashi.util.DBPowderUtils;

/**
 *  column ̒`ێB
 * TableEntity ̗vfłB
 * 
 * @author  Tadashi Murakami
 * @version $Revision: 1.1 $, $Date: 2004/08/13 07:18:42 $
 * @see     org.tadashi.dbpowder.sql.TableEntity
 * @since   --
 */
public class ColumnEntity {
  private final DBPowderCreator beanCreator;
  /** column */
  String columnName;
  /** typeID */
  int columnTypeId;
  /** type */
  String columnTypeName;
  /** lclass */
  Class fieldClass;

  /** ̔ԃJǂ */
  boolean isAutoIncrement;

  /** nullǂ */
  Boolean isNullable;

  /** { ColumnEntity ێ TableEntity */
  TableEntity parentTableEntity=null;

  ColumnEntity (DBPowderCreator bean, String columnName, int columnTypeId, String columnTypeName, String fieldClassName, boolean isAutoIncrement, int isNullable)
      throws DBPowderCreateException {
    this.columnName      = columnName;
    this.beanCreator     = bean;
    this.columnTypeId    = columnTypeId;
    this.columnTypeName  = columnTypeName;
    this.isAutoIncrement = isAutoIncrement;
    Boolean nullableObj;
    switch (isNullable){
      case ResultSetMetaData.columnNoNulls:
        nullableObj = Boolean.FALSE;
        break;
      case ResultSetMetaData.columnNullable:
        nullableObj = Boolean.TRUE;
        break;
      case ResultSetMetaData.columnNullableUnknown:
        nullableObj = null;
        break;
      default:
        throw new DBPowderCreateException("Illegal isNullable value!!:"+isNullable);
    }
    this.isNullable      = nullableObj;
    try {
      this.fieldClass   = Class.forName(fieldClassName);
    } catch (ClassNotFoundException e) {
      throw new DBPowderCreateException(e);
    }
  }

  //
  // setter, getter
  //

  public void setParentTableEntity(TableEntity entity){
    parentTableEntity=entity;
  }
  public String getColumnName() {
    return columnName;
  }
  public int getColumnTypeId() {
    return columnTypeId;
  }
  public String getColumnTypeName() {
    return columnTypeName;
  }
  public Class getFieldClass() {
    return fieldClass;
  }
  public boolean isAutoIncrement() {
    return isAutoIncrement;
  }
  public Boolean isNullable() {
    return isNullable;
  }
  /** Number ̎qNXȂ true Ԃ */
  public boolean isNumericField() {
    return Number.class.isAssignableFrom(fieldClass);
  }

  /**
   * type  instanceof ԂB
   * @param type class
   */
	public boolean instanceOf(String type) throws ClassNotFoundException {
		Class c = Class.forName(type);
		return c.isAssignableFrom(fieldClass);
	}

  /** {^ꍇA String ŕԂ */
  public String getCompatiblePrimitiveField(){
    if (!isNumericField()){
      return null;
    }
    String field = getFieldClassName();
    if ("Integer".equals(field)){
      return "int";
    }
    return StringUtils.uncapitalize(field);
  }

  /** fieldClass ̖OԂBimportς݂͒ZkɂȂ */
  public String getFieldClassName() {
    return DBPowderUtils.getClassName(fieldClass);
  }


  /** "under_score_style"  "CamelStyle" ɂ */
  public String getCamelStyleName() {
    return DBPowderUtils.getCamelStyleName(columnName);
  }

  /**
   * tableAlias ZbgĂ΁AtableAlias+"_"+columnName
   * tableAlias ZbgĂȂ΁AcolumnName
   */
  public String getColumnDesc(){
    String tableAlias = parentTableEntity.getAlias();
    if (tableAlias==null || "".equals(tableAlias)){
      return columnName;
    } else {
      return tableAlias+"_"+columnName;
    }
  }


  public String toString(){
    return "<"+columnName+":"+columnTypeName+":"+fieldClass.getName()+">";
  }
}
