/*
 * $Id: DBPowderCompiler.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.dbpowder.sql;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class DBPowderCompiler extends Task {
  public static final String CONFIG_XSD = "dbpowder-config.xsd";

//http://www.atmarkit.co.jp/bbs/phpBB/viewtopic.php?forum=12&topic=4819
  public static final String SOURCE_ROOT = DBPowderCompiler.class
          .getResource("/resources/config/"+CONFIG_XSD).getFile()
          .replaceAll ("/resources/config/"+CONFIG_XSD+"$","");

  public static final String PACKAGE_ENTITY = "entity";
  public static final String PACKAGE_DAO    = "dao";
  public static final String PACKAGE_UTIL   = "util";

  /**
   * @param arg[0] RpCΏۃev[gBdbpowder/src/resources/template/ ̉ɂ
   *                ev[gw
   * @param arg[1] ǂݍ source xml wB/΃pX̎w肪\B
   *                ΃pX̏ꍇ́Adbpowder/src/org/resources ̑΃pXɂȂ
   * @param arg[2] RpC̃pbP[Ww
   * @param arg[3] RpC̃fBNgwB/΃pX̎w肪\B
   *                ΃pX̏ꍇ́Adbpowder/.. ̑΃pXɂȂ
   */
  public static final void main(String[] arg) throws Exception {
    // Kvǂݎ
    DBPowderCompiler compiler = new DBPowderCompiler();
    compiler.setTargetTemplate(arg[0]);
    compiler.setSourceFile(arg[1]);
    compiler.setPackageName(arg[2]);
    compiler.setTargetRoot(arg[3]);

    // s
    compiler.execute();
  }


  private String targetTemplate;
  private String sourceFile;
  private String packageName;
  private String targetRoot;


  public void setTargetTemplate(String string) {
    targetTemplate = string;
  }
  public void setSourceFile(String string) {
    sourceFile = (new File(string).isAbsolute())? string:SOURCE_ROOT+"/resources/"+string;
  }
  public void setPackageName(String string) {
    packageName = string;
  }
  public void setTargetRoot(String string) {
    targetRoot = (new File(string).isAbsolute())? string:SOURCE_ROOT+"/../../"+string;
  }

  public void execute() {
    ////////////////////////////////////////
    // pXĂ
    ////////////////////////////////////////
    final String PACKAGE_ROOT_DIR = targetRoot + "/" + packageName.replaceAll("\\.", "/");
    final String TEST_ROOT_DIR = targetRoot + "/../testcase/" + packageName.replaceAll("\\.", "/");

    final String PACKAGE_ENTITY_DIR = PACKAGE_ROOT_DIR+"/"+PACKAGE_ENTITY;
    final String PACKAGE_DAO_DIR    = PACKAGE_ROOT_DIR+"/"+PACKAGE_DAO;
    final String PACKAGE_UTIL_DIR   = PACKAGE_ROOT_DIR+"/"+PACKAGE_UTIL;

    final String TEST_DAO_DIR       = TEST_ROOT_DIR+"/"+PACKAGE_DAO;


    ////////////////////////////////////////
    // Ώ dir Ȃ΍쐬
    ////////////////////////////////////////
    File[] targetDirs = new File[]{
      new File(PACKAGE_ENTITY_DIR),
      new File(PACKAGE_DAO_DIR),
      new File(PACKAGE_UTIL_DIR),
      new File(TEST_DAO_DIR)
    };

    for (int i=0; i<targetDirs.length; i++){
      if (!targetDirs[i].exists()) {
        targetDirs[i].mkdirs();
      }
    }


    ////////////////////////////////////////
    // parse
    ////////////////////////////////////////
    try {
      DBPowderCreator bean[] = DBPowderCreator.parse(sourceFile, targetTemplate);

      for (int i = 0; i < bean.length; i++) {
        final String baseNamePackageDao    = PACKAGE_DAO_DIR    + "/"+bean[i].getBeanName();
        final String baseNamePackageEntity = PACKAGE_ENTITY_DIR + "/"+bean[i].getBeanName();
        final String baseNamePackageUtil   = PACKAGE_UTIL_DIR   + "/"+bean[i].getBeanName();
        final String baseNameTestDao       = TEST_DAO_DIR       + "/"+bean[i].getBeanName();

        // table ɐ .vm
        bean[i].create("entity.vm",   baseNamePackageEntity+"Entity.java", packageName);
        bean[i].create("pk.vm",       baseNamePackageEntity+"Pk.java", packageName);
        bean[i].create("dao.vm",      baseNamePackageDao+"Dao.java", packageName);
        bean[i].create("utils.vm",    baseNamePackageUtil+"Utils.java", packageName);
        bean[i].create("operationconfig.vm", baseNamePackageDao+"OperationConfig.java", packageName);
        bean[i].create("testcase.vm", baseNameTestDao+"DaoTest.java", packageName);

        // .java.vm ́A
        if (i==0){
          bean[i].create("utils.java.vm",     PACKAGE_UTIL_DIR+ "/Utils.java", packageName);
          bean[i].create("operationconfig.java.vm",      PACKAGE_DAO_DIR + "/OperationConfig.java", packageName);
          bean[i].create("operationconfigparam.java.vm", PACKAGE_DAO_DIR + "/OperationConfigParam.java", packageName);
          bean[i].create("sqlentity.java.vm", PACKAGE_UTIL_DIR+ "/SqlEntity.java", packageName);
          bean[i].create("dialectutils.java.vm",         PACKAGE_UTIL_DIR+ "/DialectUtils.java", packageName);
        }

        // DaoTestData ́At@C݂ȂƂ̂ݐ
        String daoTestDataFile = baseNameTestDao+"DaoTestData.java";
        File file = new File(daoTestDataFile);
        if (!file.exists() /*|| true*/){
          bean[i].create("testcasedata.vm", daoTestDataFile, packageName);
        }
        System.out.println(bean[i]);
      }
    } catch (Exception e){
      e.printStackTrace();
      throw new BuildException(e);
    }
  }
}
