/*
 * $Id: DBPowderCreator.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.dbpowder.sql;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.sql.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

import org.tadashi.tools.sql.ConnectionBuilder;
import org.tadashi.util.VelocityUtils;


import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.tadashi.dbpowder.jaxb.Join;
import org.tadashi.dbpowder.jaxb.Powder;
import org.tadashi.dbpowder.jaxb.DbpowderConfig;

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class DBPowderCreator {
//  static public final String TAB   = "  ";
//  static public final String QUOTE = "\"";

  public static final String JAXB_PACKAGE = "org.tadashi.dbpowder.jaxb";

  private String targetTemplate;

  /** Powder ̖O */
  private String beanName;

  /** join ̑匳ƂȂe[u */
  TableEntity tableEntity = null;

  /** JoinDefEntityArray */
  private JoinDefEntity[] joinDefEntityArray = null;

  private DBPowderCreator(String targetTemplate){
    this.targetTemplate = targetTemplate;
  }

  /**
   * xml  parse
   */
  static public final DBPowderCreator[] parse(String fileName, String targetTemplate) throws DBPowderCreateException, SQLException, JAXBException {
    List ret = new ArrayList();

    // Context  Unmarshaller ̎擾
    // https://jaxb.dev.java.net/faq/#classloader QƂ̂
    JAXBContext context = JAXBContext.newInstance(JAXB_PACKAGE, DBPowderCreator.class.getClassLoader());
    Unmarshaller unmarshaller = context.createUnmarshaller();

    //؋@\̗L
    unmarshaller.setValidating(true);
    
    //XMLǂݍށiA}[V)
    DbpowderConfig dbpowderConfig = (DbpowderConfig)unmarshaller.unmarshal(new File(fileName));

    //vf key ̃Xgo
    List powderBeanList = dbpowderConfig.getPowder();
    if (powderBeanList != null){
      Iterator powderBeanIterator = powderBeanList.iterator();
      while (powderBeanIterator.hasNext()){
        Powder powder = (Powder)powderBeanIterator.next();

        ////////////////////
        // vf擾
        ////////////////////
        String nameStr   = powder.getName();
        String tableStr  = powder.getTable();
        String pKeyStr   = powder.getPkey();
        List   joinList  = powder.getJoin();

        DBPowderCreator beanCreator = new DBPowderCreator(targetTemplate);

        ////////////////////
        // 擾vf bean Ɋi[
        ////////////////////
        beanCreator.setBeanName(nameStr);

        // e[uǂݍ
        TableEntity tableEntity = DBPowderCreator.readTables(tableStr, beanCreator, beanCreator.getBeanName(), pKeyStr.split("\\s*,\\s*"));
        beanCreator.tableEntity = tableEntity;

        // e[uǂݍ
        Iterator joinIterator = joinList.iterator();
        List joinDefEntityList = new ArrayList();
        while (joinIterator.hasNext()){
          Join join = (Join)joinIterator.next();

          // update̗LA
          boolean isUpdate = join.isIsUpdate();
          String relation = join.getRelation();
          String alias    = join.getAlias();

          // Join ̓ǂݎ
          String keyJoin[], keyJoined[];
          String bindStr = join.getBind();
          String key[] = bindStr.trim().split("\\s*=\\s*");
          keyJoin   = key[0].split("\\s*,\\s*");
          keyJoined = key[1].split("\\s*,\\s*");
          // w肪ȂAL[̌قȂ肷΁AG[
          if (keyJoin.length==0 || keyJoin.length!=keyJoined.length){
            throw new DBPowderCreateException("Illegal assign of join#key: "+bindStr);
          }
          // JoinL[ɁAalias ̎w肪Ȃ΁AG[
          for (int i=0; i<keyJoin.length; i++){
            if (!keyJoin[i].startsWith(alias+".")){
              throw new DBPowderCreateException("Need to assign alias at ["+keyJoin[i]+"]: "+bindStr);
            }
            keyJoin[i] = keyJoin[i].substring(alias.length()+1);
          }

          String mulName = (String)join.getContent().get(0);
          joinDefEntityList.add (new JoinDefEntity(beanCreator, mulName, alias, keyJoin, keyJoined, isUpdate, relation));
        }

        beanCreator.joinDefEntityArray = (JoinDefEntity[])joinDefEntityList.toArray(new JoinDefEntity[0]);

        ret.add(beanCreator);
      }
    }

    return (DBPowderCreator[])ret.toArray(new DBPowderCreator[0]);
  }

  /**
   * Ώۃe[uAXL[}擾
   * FROM 𕪉āA擾
   */
  private static TableEntity readTables(String tableName, DBPowderCreator creator, String beanName, String[] pkey) throws SQLException, DBPowderCreateException {
    System.out.println("=========="+beanName+"==========");
    Connection conn = ConnectionBuilder.getConnection();

    StringBuffer sql = new StringBuffer("SELECT * FROM "+tableName+" WHERE 0=1");
    for (int i=0; i<pkey.length; i++){
      sql.append(" AND "+pkey[i]+"!="+pkey[i]);
    }
    ResultSet rs = conn.prepareStatement(sql.toString()).executeQuery();
    ResultSetMetaData meta = rs.getMetaData();
    List columnEntityList = new ArrayList();
    for (int i=1; i<=meta.getColumnCount(); i++){
      String catalogName       = meta.getCatalogName       (i);
      String columnClassName   = meta.getColumnClassName   (i);
      int    columnDisplaySize = meta.getColumnDisplaySize (i);
      String columnLabel       = meta.getColumnLabel       (i);
      String columnName        = meta.getColumnName        (i);
      int    columnType        = meta.getColumnType        (i);
      String columnTypeName    = meta.getColumnTypeName    (i);
      int    precision         = meta.getPrecision         (i);
      int    scale             = meta.getScale             (i);
      String schemaName        = meta.getSchemaName        (i);
//        String tableName         = meta.getTableName         (i);
      boolean isAutoIncrement      = meta.isAutoIncrement     (i);
      boolean isCaseSensitive      = meta.isCaseSensitive     (i);
      boolean isCurrency           = meta.isCurrency          (i);
      boolean isDefinitelyWritable = meta.isDefinitelyWritable(i);
      int     isNullable           = meta.isNullable          (i);
      boolean isReadOnly           = meta.isReadOnly          (i);
      boolean isSearchable         = meta.isSearchable        (i);
      boolean isSigned             = meta.isSigned            (i);
      boolean isWritable           = meta.isWritable          (i);

      ColumnEntity col = new ColumnEntity(creator, columnName, columnType, columnTypeName, columnClassName, isAutoIncrement, isNullable);
      columnEntityList.add(col);
    }

    TableEntity tableEntity = new TableEntity(creator, tableName, pkey/*,tableAlias*/,(ColumnEntity[])columnEntityList.toArray(new ColumnEntity[0]) /*, joinEntity*/);

    rs.close();
    conn.close();
    return tableEntity;
  }


  /**
   * readTables ̌ʂAt@C쐬
   */
  public void create(String templateFile, String targetFile, String packageName) throws FileNotFoundException, Exception {
    boolean isCloseStreamLast = true; // System.out ̎ false ɂ

    VelocityContext context = new VelocityContext();
    context.put("packageName", packageName);
    context.put("beanName", beanName);
		context.put("tableEntity", tableEntity);

    context.put("joinDefEntityList", joinDefEntityArray);
		context.put("DIR_TEMPLATE", VelocityUtils.DIR_TEMPLATE+targetTemplate+"/");

    List list = new ArrayList();
    for (int i=0; i<tableEntity.getPkey().length; i++){
      ColumnEntity columnEntity = getColumnEntity(tableEntity.getPkey()[i]);
      if (columnEntity == null){
        throw new DBPowderCreateException("Illegal publicKey!! "+tableEntity.getPkey()[i]);
      }
      list.add(columnEntity);
    }
    context.put("pkColumnEntityList", list);

    context.put("createDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").format(Calendar.getInstance().getTime()));


    Template template = VelocityUtils.getTemplate(targetTemplate+"/"+templateFile);
    PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
//    PrintStream out = System.out;
    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
    if ( template != null) {
        template.merge(context, writer);
    }
    writer.flush();

    if (isCloseStreamLast){
      out.close();
    }
  }


  public String toString(){
    StringBuffer ret = new StringBuffer();

    ret.append("|pkey{"+StringUtils.join(tableEntity.getPkey(),",")+"}");

    ret.append("|");
    if (joinDefEntityArray!=null){
      for (int i=0; i<joinDefEntityArray.length; i++){
        ret.append(joinDefEntityArray[i].toString());
      }
    }
//    return beanName+"=["+baseSql+ret+"@"+StringUtils.join(tableEntity,"|")+"]";
//		return beanName+"=["+baseSql+ret+"@"+rootTableDef+"]";
    return beanName+"=["+ret+"@"+tableEntity+"]";
  }


  /**
   * @return
   */
  public String getBeanName() {
    return beanName;
  }


  /**
   * @param string
   */
  private void setBeanName(String string) {
    beanName = string;
  }

  /**
   * @return
   */
  public String[] getPkey() {
    return tableEntity.getPkey();
  }


  /**
   * @return
   */
  public TableEntity[] getTableDef() {
    TableEntity[] entity = new TableEntity[]{tableEntity};
    return entity;
  }
  /**
   * @return
   */
  public ColumnEntity getColumnEntity(String columnName) {
    ColumnEntity column = (ColumnEntity)tableEntity.getColumnEntity(columnName);
    if (column != null){
      return column;
    }
    return null;
  }

}
