/*
 * $Id: JoinDefEntity.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.dbpowder.sql;

import java.util.*;
import org.apache.commons.lang.StringUtils;
import org.tadashi.util.DBPowderUtils;


/**
 * BeanɎA̃Tuf[^
 */

public class JoinDefEntity {
  private final DBPowderCreator beanCreator;

  /** Tuf[^̃NX */
  String name;

  /** Tuf[^alias */
  String alias;

  /** Tuf[^擾̂߂̃L[ */
	JoinKeyEntity[] joinKeyEntityList;

	boolean isUpdate;
	boolean isKeyParent;
  boolean isKeyOne;


	JoinDefEntity(DBPowderCreator bean, String name, String alias, String[] keyJoin, String[] keyJoined, boolean isUpdate, String relation){
    this.name  = name;
    this.alias = alias;
		this.beanCreator = bean;
		this.isUpdate    = isUpdate;
    if ("child.one".equals(relation)){
      isKeyParent = false;
      isKeyOne    = true;
    } else if ("child.many".equals(relation)){
      isKeyParent = false;
      isKeyOne    = false;
    } else /* if ("parent.one".equals(relation)) */ {
      isKeyParent = true;
      isKeyOne  = true;
    }

		List list = new ArrayList();
		for (int i=0; i<keyJoin.length; i++){
			JoinKeyEntity entity = new JoinKeyEntity(keyJoin[i], keyJoined[i]);
			list.add(entity);
		}
		joinKeyEntityList = (JoinKeyEntity[])list.toArray(new JoinKeyEntity[0]);
	}


  public String getName() {
    return name;
  }
  public String getAlias() {
    return alias;
  }
  /** 擪āAbeanԂ */
  public String getUncapitalizedName() {
    return StringUtils.uncapitalize(name);
  }
  /** under_score_style_name ɂĕԂ */
  public String getUnderScoreStyleName(){
    return DBPowderUtils.getUnderScoreStyleName(getName());

  }

	public JoinKeyEntity[] getJoinKeyEntityList() {
		return joinKeyEntityList;
	}

  /**
   * @return
   */
  public boolean isKeyParent() {
    return isKeyParent;
  }

  /**
   * @return
   */
  public boolean isKeyOne() {
    return isKeyOne;
  }

	/**
	 * @return
	 */
	public boolean isUpdate() {
		return isUpdate;
	}


	public String toString(){
		return "{Multiple("+name+":"+StringUtils.join(joinKeyEntityList,",")+")}";
	}
}
