/*
 * $Id: TableEntity.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.dbpowder.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import org.tadashi.util.DBPowderUtils;


/**
 * table `
 */
public class TableEntity {
  private final DBPowderCreator beanCreator;
  /** table */
  String tableName;
  /** tablealias */
  String alias;

  /** tablepkey */
  String[] pkey;

  /** column` */
  ColumnEntity[] columnEntity;

  /** ̔ԃJ */
  String[] autoIncrementColumns;

  /** ̔ԃJ getter, setter B */
  String[] autoIncrementGetterSetters;

  /** column` */
//  JoinEntity joinEntity = null;

  /** columnEntity Map */
  Map columnEntityMap = new HashMap();

  Map extraStringMap = new HashMap();

  TableEntity (DBPowderCreator bean, String tableName, String[] pkey/*, String alias*/, ColumnEntity[] columnEntity /*, JoinEntity joinDef*/) {
    this.tableName = tableName;
    this.beanCreator = bean;
    this.pkey = pkey;
//    this.alias = alias;
    this.columnEntity = columnEntity;

    List autoIncrementList      = new ArrayList();
    List autoIncrementCamelList = new ArrayList();

    for (int i=0; i<columnEntity.length; i++){
      columnEntity[i].setParentTableEntity(this);
      columnEntityMap.put(DBPowderUtils.getString("",alias,".")+columnEntity[i].columnName, columnEntity[i]);

      if (columnEntity[i].isAutoIncrement()){
        String columnName = columnEntity[i].getColumnName();
        String camelName  = columnEntity[i].getCamelStyleName();
        autoIncrementList.add(columnName);
        autoIncrementCamelList.add(camelName);
      }
    }
    autoIncrementColumns       = (String[])autoIncrementList.toArray(new String[0]);
    autoIncrementGetterSetters = (String[])autoIncrementCamelList.toArray(new String[0]);

//    this.joinEntity = joinDef;
  }

  public String getAlias() {
    return alias;
  }
  public void setAlias(String alias) {
    this.alias = alias;
  }

  public String[] getPkey() {
    return pkey;
  }

  /** aliasłȂ΁AʂŕԂ */
  public String getAliasWithParenthesis() {
    return DBPowderUtils.getString(" (",getAlias(),")");
  }
  /** aliasłȂ΁A _ t */
  public String getAliasAndBar() {
    return DBPowderUtils.getString("",getAlias(),"_");
  }
  /** alias擪啶ɂĕԂ */
  public String getAliasCapitalize() {
    return StringUtils.capitalize(StringUtils.defaultString(getAlias()));
  }


  public ColumnEntity[] getColumnEntity() {
    return columnEntity;
  }
  public ColumnEntity getColumnEntity(String columnName) {
    return (ColumnEntity)columnEntityMap.get(columnName);
  }
  public String getTableName() {
    return tableName;
  }

/*
  public String[] getJoinKeys() throws SqlBeanCreateException {
    if (joinEntity==null){
      return null;
    }
    return joinEntity.getKey(this.getAlias());

  }
	public String[] getJoinTargets() throws SqlBeanCreateException {
		if (joinEntity==null){
			return null;
		}
		return joinEntity.getTarget(this.getAlias());
	}
*/


  public void putExtraMap(String key, Object val){
    extraStringMap.put(key, val);
  }
  public Object getExtraMap(String key){
    return extraStringMap.get(key);
  }


  public String toString(){
    return "{"+tableName+StringUtils.join(columnEntity,"")+"}";
  }
  /**
   * @return
   */
  public String[] getAutoIncrementColumnNames() {
    return autoIncrementColumns;
  }

	public int getAutoIncrementColumnsCount() {
		return autoIncrementColumns.length;
	}

  /**
   * @return
   */
  public String[] getAutoIncrementGetterSetterNames() {
    return autoIncrementGetterSetters;
  }
	/**
	 * @return
	 */
	public String getAutoIncrementGetterSetterName() {
		return autoIncrementGetterSetters[0];
	}

}