/*
 * $Id: ConnectionBuilder.java,v 1.1 2004/08/13 07:16:19 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.tools.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

import org.tadashi.util.DBPowderUtils;

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class ConnectionBuilder {
  /** Connection擾 */
  static public final Connection getConnection() throws SQLException {
    String propName = DBPowderUtils.getBundle("defaultConnection", "dbpowder");
    return getConnection(propName);
  }

  /** Connection擾 */
  static public final Connection getConnection(String propName) throws SQLException {
    ConnectionFactory factory;
    String className = DBPowderUtils.getBundle("connectionFactoryClass", propName);
    try {
      Class factoryClass = Class.forName(className);
      Method method = factoryClass.getMethod("getInstance",null);
      factory = (ConnectionFactory)method.invoke(null,null);
    } catch (Exception e){
      throw new RuntimeException(e);
    }
    return factory.getConnection();
  }
}
