/*
 * $Id: DriverManagerConnectionFactoryImpl.java,v 1.1 2004/08/13 07:16:19 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.tools.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.tadashi.util.DBPowderUtils;

/*
<%@ page import="javax.naming.*" %>
<%@ page import="javax.sql.*" %>
<%@ page import="java.sql.*" %>
 */

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class DriverManagerConnectionFactoryImpl implements ConnectionFactory {
  /** singleton */
  static private final ConnectionFactory connFactory = new DriverManagerConnectionFactoryImpl();
  private DriverManagerConnectionFactoryImpl(){}

  /** B̃CX^X擾 */
  public static final ConnectionFactory getInstance(){
    return connFactory;
  }

  /** Connection擾 */
  public final Connection getConnection(String propertyName) throws SQLException {
//  InitialContext ic = new InitialContext();
//  DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/pgremote/lyceum");
//  Connection conn = ds.getConnection();
    String dbms   = DBPowderUtils.getBundle("dbms", propertyName);
    String driver = DBPowderUtils.getBundle("driver", propertyName);
    String url    = DBPowderUtils.getBundle("url", propertyName);
    String user   = DBPowderUtils.getBundle("user", propertyName);
    String pass   = DBPowderUtils.getBundle("pass", propertyName);

    try {
      Class.forName(driver);
    } catch (ClassNotFoundException e){
      throw new SQLException("ClassNotFoundException: "+driver+"\n"+e.toString());
    }
		Connection conn = DriverManager.getConnection(url, user, pass);

    conn.setAutoCommit(false);
    return conn;
  }


  /** Connection擾 */
  public Connection getConnection() throws SQLException {
    String dbms = DBPowderUtils.getBundle("defaultConnection","dbpowder");
    return getConnection(dbms);
  }
}
