/*
 * $Id: DBPowderUtils.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.apache.commons.lang.StringUtils;

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class DBPowderUtils {
  /**
   * preString+target+postString Ԃ
   * AAtarget Ȃ΁A"" Ԃ
   */
  static public final String getString(String preString, String target, String postString){
    if (target==null || "".equals(target)){
      return "";
    }
    return preString+target+postString;
  }

  /**
   * preString+target+postString Ԃ
   * AAtarget Ȃ΁A"" Ԃ
  static public final String getIterateString(String str, int numIteration){
    StringBuffer ret = new StringBuffer();
    for (int i=0; i<numIteration; i++){
      ret.append(str);
    }
    return ret.toString();
  }
   */

  /** "under_score_style"  "CamelStyle" ɂ */
  static public String getCamelStyleName(String name) {
    String[] splitName = name.split("_");
    for (int i=0; i<splitName.length; i++){
      splitName[i] = StringUtils.capitalize(splitName[i]);
    }
    return StringUtils.join(splitName,"");
  }

  /** "CamelStyle"  "under_score_style" ɂ */
  static public String getUnderScoreStyleName(String name) {
    char[] nameChar = name.toCharArray();
    StringBuffer buf = new StringBuffer();
    for (int i=0; i<nameChar.length; i++){
      if ('A' <= nameChar[i] && nameChar[i] <= 'Z'){
        buf.append("_"+StringUtils.lowerCase(nameChar[i]+""));
      } else {
        buf.append(nameChar[i]);
      }
    }
    String ret = buf.toString();
    if (ret.startsWith("_")){
      ret = ret.substring(1);
    }
    return ret;
  }

  /**
   * class ̖OԂ
   * import ς݂̂̂ɂẮApbP[W܂߂Ȃ
   */
  public static final String getClassName(Class c){
    return c.getName().replaceAll("java.lang.","");
  }

  public static String getBundle(String key, String resourceName) {
    ResourceBundle resource = null;
    try {
      resource = ResourceBundle.getBundle("resources/dbpowder/"+resourceName);
      if (resource == null){
        throw new MissingResourceException("resources/dbpowder/"+resourceName+".properties NOT FOUND!!", resourceName, key);
      }
    } catch (MissingResourceException e){
      throw e;
//      throw new IllegalBundleException(e);
    }

    try {
      return resource.getString(key);
    } catch (MissingResourceException e){
      throw e;
//      throw new IllegalBundleException(e);
    }
  }
}
