/*
 * $Id: VelocityUtils.java,v 1.1 2004/08/13 07:18:42 tadashi75 Exp $
 * 
 * DBPowder ver0.5  2004/08/08
 * 
 * Copyright (c) 2004 Tadashi Murakami. All rights reserved.
 * Use is subject to license terms.
 */

package org.tadashi.util;

import java.io.FileNotFoundException;

import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * @author tadashi
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class VelocityUtils {
	public static final String DIR_TEMPLATE;

  static {
    try {
      String dirTemplate = "resources/template/";
      try {
        Velocity.init(dirTemplate+"../config/velocity.properties");
      } catch (FileNotFoundException e){
        // for eclipse...
        dirTemplate = "src/resources/template/";
        Velocity.init(dirTemplate+"../config/velocity.properties");
      }
      DIR_TEMPLATE = dirTemplate;
    } catch (Exception e){
      e.printStackTrace();
      throw new RuntimeException(e);
    }
  }

  static public final Template getTemplate(String templateFile) throws Exception {
    Template template;
    try {
        template = Velocity.getTemplate(DIR_TEMPLATE+templateFile);
    } catch( ResourceNotFoundException rnfe ) {
        throw rnfe;
//        System.out.println("Example : error : cannot find template " + templateFile );
    } catch( ParseErrorException pee ) {
        throw pee;
//        System.out.println("Example : Syntax error in template " + templateFile + ":" + pee );
    }
    return template;
  }
}
