/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt.vo;

import org.eclipse.jface.preference.IPreferenceStore;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.CodeGenerator;
import zigen.plugin.db.ext.jdt.vo.rule.DefaultVOMappingFactory;
import zigen.plugin.db.ext.jdt.vo.rule.IVOMappingFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class VOGenerator
extends CodeGenerator {
    private String prefix = "Vo";
    private ITable table;
    private TreeLeaf[] leafs;
    boolean underLineCut = false;
    String accessModifiers = "private";
    IVOMappingFactory mapping;

    public VOGenerator(ITable table) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.underLineCut = store.getBoolean("GeneratePreferencePage.UnderLineCut");
        this.accessModifiers = store.getString("GeneratePreferencePage.AccessModifiers");
        this.table = table;
        this.leafs = table.getChildrens();
        this.mapping = DefaultVOMappingFactory.getFactory(table.getDbConfig());
    }

    private void do_property() {
        int i = 0;
        while (i < this.leafs.length) {
            Column col = (Column)this.leafs[i];
            this.println("\t/**");
            this.println("\t * " + col.getLogicalColumnLabel());
            this.println("\t */");
            this.println("\t" + this.propertyString(this.accessModifiers, this.getJavaType(col), this.getProperty(col)));
            this.println();
            ++i;
        }
    }

    private void do_method() {
        int i = 0;
        while (i < this.leafs.length) {
            Column col = (Column)this.leafs[i];
            this.getMethod(this.getJavaType(col), this.getProperty(col));
            this.setMethod(this.getJavaType(col), this.getProperty(col));
            ++i;
        }
    }

    private void do_import() {
        this.println("import java.io.Serializable;");
        this.println();
    }

    private void do_classBegin() {
        this.println("public class " + this.getClassName() + " implements Serializable{");
        this.println();
    }

    private void do_classEnd() {
        this.println("}");
    }

    private void do_tableDefine() {
        this.println("\tpublic static final String TABLE = \"" + this.table.getName().toUpperCase() + "\";");
        this.println();
    }

    public void execute() {
        super.setGenerateInfo();
        this.do_import();
        super.setClassComment();
        this.do_classBegin();
        this.do_tableDefine();
        this.do_property();
        this.do_constractor();
        if (this.hasPrimaryKey()) {
            this.do_constractor2();
        }
        this.do_method();
        this.do_toString();
        this.do_classEnd();
    }

    private void do_constractor() {
        this.println("\t/**");
        this.println("\t* Constractor");
        this.println("\t*/");
        this.println("\tpublic " + this.getClassName() + "(){}");
        this.println();
    }

    private void do_constractor2() {
        Column col;
        this.println("\t/**");
        this.println("\t* Constractor");
        int i = 0;
        while (i < this.leafs.length) {
            Column col2 = (Column)this.leafs[i];
            if (col2.getPkColumn() != null) {
                this.println("\t* @param <code>" + this.getProperty(col2) + "</code>");
            }
            ++i;
        }
        this.println("\t*/");
        this.print("\tpublic " + this.getClassName() + "(");
        int pkCount = 0;
        int i2 = 0;
        while (i2 < this.leafs.length) {
            col = (Column)this.leafs[i2];
            if (col.getPkColumn() != null) {
                if (pkCount == 0) {
                    this.print(String.valueOf(this.getJavaType(col)) + " " + this.getProperty(col));
                } else {
                    this.print(", " + this.getJavaType(col) + " " + this.getProperty(col));
                }
                ++pkCount;
            }
            ++i2;
        }
        this.println("){");
        i2 = 0;
        while (i2 < this.leafs.length) {
            col = (Column)this.leafs[i2];
            if (col.getPkColumn() != null) {
                this.println("\t\tthis." + this.getProperty(col) + " = " + this.getProperty(col) + ";");
            }
            ++i2;
        }
        this.println("\t}");
        this.println();
    }

    public String getClassName() {
        String str = this.table.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(str.substring(0, 1).toUpperCase());
        sb.append(str.substring(1, str.length()).toLowerCase());
        sb.append(this.prefix);
        return sb.toString();
    }

    private void getMethod(String type, String property) {
        this.println("\tpublic " + type + " " + this.getterString(property) + "(){ return this." + property + "; }");
        this.println();
    }

    private void setMethod(String type, String property) {
        this.println("\tpublic void " + this.setterString(property) + "(" + type + " " + property + "){ this." + property + " = " + property + "; }");
        this.println();
    }

    private void do_toString() {
        String[] properties = new String[this.leafs.length];
        int i = 0;
        while (i < this.leafs.length) {
            Column col = (Column)this.leafs[i];
            properties[i] = this.getProperty(col);
            ++i;
        }
        this.println(this.toStringString(this.getClassName(), properties));
    }

    private String getJavaType(Column col) {
        TableColumn tCol = col.getColumn();
        return this.mapping.getJavaType(tCol);
    }

    private String getProperty(Column col) {
        TableColumn tCol = col.getColumn();
        if (!this.underLineCut) {
            return tCol.getColumnName().toLowerCase();
        }
        String str = tCol.getColumnName().toLowerCase();
        return this.removeUnderLine(str);
    }

    protected String removeUnderLine(String strSrc) {
        int nLen = strSrc.length();
        StringBuffer sb = new StringBuffer(nLen * 2);
        int i = 0;
        while (i < nLen) {
            char c = strSrc.charAt(i);
            switch (c) {
                case '_': {
                    if (i >= nLen - 1) break;
                    char next = strSrc.charAt(++i);
                    String s = new String(new char[]{next});
                    sb.append(s.toUpperCase());
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean hasPrimaryKey() {
        int i = 0;
        while (i < this.leafs.length) {
            Column col = (Column)this.leafs[i];
            TablePKColumn pkColumn = col.getPkColumn();
            if (pkColumn != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

