/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt.vo.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.jdt.vo.rule.DefaultVOMappingFactory;
import zigen.plugin.db.ext.jdt.vo.rule.H2VOMappingFactory;
import zigen.plugin.db.ext.jdt.vo.rule.IVOMappingFactory;

public abstract class AbstractVOMappingFactory
implements IVOMappingFactory {
    private static Map map = new HashMap();

    public static IVOMappingFactory getFactory(IDBConfig config) {
        return AbstractVOMappingFactory.getFactory(config.getDriverName());
    }

    public static IVOMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
        try {
            return AbstractVOMappingFactory.getFactory(objMet.getDriverName());
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("DriverName\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public static IVOMappingFactory getFactory(String driverName) {
        IVOMappingFactory factory = null;
        String key = driverName;
        if (map.containsKey(key)) {
            factory = (IVOMappingFactory)map.get(key);
        } else {
            switch (DBType.getType((String)driverName)) {
                case 8: {
                    factory = new H2VOMappingFactory();
                    break;
                }
                default: {
                    factory = new DefaultVOMappingFactory();
                }
            }
            map.put(key, factory);
        }
        return factory;
    }
}

