/** CListBuilder
 *
 *  @file   DIBitsConverter.cpp
 *  @author Y.Kameda
 *  @date   2003/7/12
 *
 */

#include "DIBitsConverter.h"
#include "Result.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CDIBitsConverter::CDIBitsConverter()
{
	_src_data = NULL;
	_column = _row = _allocate_bits = _center = _width = 0;
}

CDIBitsConverter::~CDIBitsConverter()
{
	delete [] _src_data;
}

/** f[^Zbg
 * Eallocate_bits816łȂconvertɎs
 * Esamples_per_pixel13łȂconvertɎs
 */
void CDIBitsConverter::setData( const void* src_data, int column, int row, int allocate_bits, int samples_per_pixel )
{
	int data_size = column * row * ( allocate_bits / 8 ) * samples_per_pixel;
	_column = column;
	_row    = row;
	_allocate_bits = allocate_bits;
	_src_data = new unsigned char[data_size];
	memcpy( _src_data, src_data, data_size );
}

/** KZbg
 *
 */
void CDIBitsConverter::setWindow( int center, int width, bool reverse )
{
	_center  = center;
	_width   = width;
	_reverse = reverse;
}

/** convert̏o͂ɕKvȃTCY(Byte)Ԃ
 *
 */
int CDIBitsConverter::getOutputSize()
{
	int dst_column = _column * samples_per_pixel;
	int align_column = ( dst_column % 4 )? ( dst_column + 4 ) / 4 * 4: dst_column;
	return align_column * _row;
}

/* 24bitrbg}bvf[^o͂
 * Edibits_dataɂ͂炩ߕKvȃTCYmۂĂȂƂȂB
 *  KvȃTCYgetOutputSize()Ŏ擾ł
 */
CResult CDIBitsConverter::convert( void* dibits_data )
{
	CResut result;
	if( _allocate_bits != 8 && _allocate_bits != 16 ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CDIBitsConverterallocate_bits8,16ȊÕf[^̓T|[gĂ܂" );
		return result;
	}

	if( _samples_per_pixel != 1 && _samples_per_pixel != 3 ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CDIBitsConvertersamples_per_pixel1,3ȊÕf[^̓T|[gĂ܂" );
		return result;
	}


}

