/** CTokenNX
 *
 *  @file Token.h
 *  @author Y.Kameda
 *  @date 2003/4/23
 *
 */

#ifndef INCLUDE_TOKEN_H
#define INCLUDE_TOKEN_H

#include <string>
using namespace std;

namespace dcl{

/** CToken̎ގʎq
 *
 */
enum TOKEN_TYPE{
	TOKEN_PREAMBLE, /// t@CvAu
	TOKEN_DICM,     /// DICMvtBbNX
	TOKEN_ELEMENT,  /// ^Ovf
	TOKEN_BLOKEN,   /// ^ȎOɃt@CI[Ă܂BtH[}bgG[
	TOKEN_END_POS   /// t@Cif[^jI[
};

/** VR̃^Cvʎq
 *
 */
enum VR_TYPE{
	VR_UN,  // sȃoCg
	VR_AE,  // ő16oCg
	VR_AS,  // 4oCgŒ蕶
	VR_AT,  // 4oCgŒ葮^O
	VR_CS,  // ő16oCg
	VR_DA,  // t8oCgŒ(ƂȂ10oCĝƂ)
	VR_DS,  // 10i(ő16oCg)
	VR_DT,  // ʃf[^^Cv
	VR_FL,  // Px_(4oCgŒ)
	VR_FD,  // {x_(8oCgŒ)
	VR_IS,  // 
	VR_LO,  // ő64oCg
	VR_LT,  // ő10240oCg
	VR_OB,  // ]\ɂĈӖقȂoCg
	VR_OW,  // rbOGfBAAgGfBAŃXbsOKvȃoCg
	VR_PN,  // l
	VR_SH,  // ő16oCg
	VR_SL,  // t(4oCgŒ)
	VR_SQ,  // V[PX^O
	VR_SS,  // tZ(2oCgŒ)
	VR_ST,  // ő1024oCg
	VR_TM,  // ԍő16oCg
	VR_UI,  // UID ő64oCg
	VR_UL,  // Ȃ(4oCgŒ)
	VR_US,  // Ȃ(2oCgŒ)
	VR_UT,   // eLXg
	VR_OTHER // ǂłȂIVR`̃oCgBۑƂUNɂĕۑBUNƓƉ߂Č\
};

/** VRԂ
 *
 */
string Vr2Str( VR_TYPE vr );

#if 0
// ctn̐錾
typedef enum {
    DCM_AE,			/* Application Entity */
    DCM_AS,			/* Age string */
    DCM_AT,			/* Attribute tag */
    DCM_CS,			/* Control string */
    DCM_DA,			/* Date */
    DCM_DD,			/* Data set */
    DCM_DS,			/* Decimal string */
    DCM_FD,			/* Floating double */
    DCM_FL,			/* Float */
    DCM_IS,			/* Integer string */
    DCM_LO,			/* Long string */
    DCM_LT,			/* Long text */
    DCM_OT,			/* Other binary value */
    DCM_SH,			/* Short string */
    DCM_SL,			/* Signed long */
    DCM_SQ,			/* Sequence of items */
    DCM_SS,			/* Signed short */
    DCM_ST,			/* Short text */
    DCM_TM,			/* Time */
    DCM_UI,			/* Unique identifier (UID) */
    DCM_UL,			/* Unsigned long */
    DCM_UN,			/* Unknown (DICOM Unknown) */
    DCM_US,			/* Unsigned short */
    DCM_UNKNOWN,		/* Unknown/unspecified (non-standard) */
    DCM_RET,			/* Retired */
    DCM_CTX,			/* Context sensitive (non-standard) */
    DCM_PN,			/* Person Name */
    DCM_OB,			/* Other, byte */
    DCM_OW,			/* Other, word */
    DCM_DT,			/* Date/Time */
    DCM_DLM,			/* Delimiter (non-standard) */
    DCM_UT			/* Unlimited text */
}   DCM_VALUEREPRESENTATION;
#endif

/** CPerserǂݍ񂾃g[NNX
 *
 *  ̃NXCPerserCBuilderւ̏̓`BɎgB
 *
 */
class CToken
{
private:
	TOKEN_TYPE     m_type;
	unsigned short m_group;
	unsigned short m_element;
	VR_TYPE        m_vr;
	int            m_length;
	int            m_fail_length;
	unsigned char* m_data;
	unsigned long  m_tag_pos;
	unsigned long  m_data_pos;

public:
	CToken();
	~CToken();
	TOKEN_TYPE     GetType() const;       ///< f[^ނԂ
	unsigned short GetGroup() const;      ///< O[vԍԂ
	unsigned short GetElement() const;    ///< GgԍԂ
	VR_TYPE        GetVR() const;         ///< 3ByteڂNULL~߂ꂽVRԂB
	int            GetFailLength() const; ///< TYPE_BLOKEN̎̂ݗLB^ÕOXɃZbgĂlB
	int            GetLength() const;     ///< f[^
	const unsigned char* GetData() const; ///< f[^ւ̃|C^BNULL͕ԂȂB
	unsigned long  GetTagPos() const;     ///< ^O̐擪̃ItZbg
	unsigned long  GetDataPos() const;    ///< f[^̐擪̃ItZbg

	void Clear();
	void SetType( TOKEN_TYPE );           ///< f[^ނԂ
	void SetGroup( unsigned short );      ///< O[vԍԂ
	void SetElement( unsigned short );    ///< GgԍԂ
	void SetVR( VR_TYPE );                ///< 3ByteڂNULL~߂ꂽVRԂB
	void SetFailLength( int );            ///< TYPE_BLOKEN̎̂ݗLB^ÕOXɃZbgĂlB
	void SetData( const unsigned char* data, int length); /// f[^ւ̃|C^BNULL͕ԂȂB
	void SetTagPos( unsigned long );      ///< ^O̐擪̃ItZbg
	void SetDataPos( unsigned long );     ///< f[^̐擪̃ItZbg

};

}

#endif
