/** CListBuilder
 *
 *  @file   DIBitsConverter.cpp
 *  @author Y.Kameda
 *  @date   2003/7/12
 *
 */

#include "DIBitsConverter.h"
#include "Result.h"

using namespace dcl;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CDIBitsConverter::CDIBitsConverter()
{
	_src_data = NULL;
	_column = _row = _allocate_bits = _stored_bits = _center = _width = _samples_per_pixel = 0;
	_reverse = false;
	_representation = false;

	// Kϊe[u
	_table = new unsigned char[1];
	_table[0] = 0;
	_table_min = 0;
	_table_max = 0;
	_table_size = 0;
	_table_center = _table_width = 0;
	_table_reverse = false;
}

CDIBitsConverter::~CDIBitsConverter()
{
	delete [] _src_data;
}

/** f[^Zbg
 * Eallocate_bits816łȂconvertɎs
 * Esamples_per_pixel13łȂconvertɎs
 */
void CDIBitsConverter::setData( const void* src_data, int column, int row, int allocate_bits, int stored_bits, int samples_per_pixel, bool representation )
{
	int data_size = column * row * ( allocate_bits / 8 ) * samples_per_pixel;
	_column = column;
	_row    = row;
	_allocate_bits = allocate_bits;
	_stored_bits = stored_bits;
	_samples_per_pixel = samples_per_pixel;
	_representation = representation;
	_src_data = new unsigned char[data_size];
	memcpy( _src_data, src_data, data_size );
}

/** KZbg
 *
 */
void CDIBitsConverter::setWindow( int center, int width, bool reverse )
{
	_center  = center;
	_width   = width;
	_reverse = reverse;
}

/** convert̏o͂ɕKvȃTCY(Byte)Ԃ
 *
 */
int CDIBitsConverter::getOutputSize()
{
	int dst_column = _column * 3;
	int align_column = ( dst_column % 4 )? ( dst_column + 4 ) / 4 * 4: dst_column;
	return align_column * _row;
}

/* 24bitrbg}bvf[^o͂
 * Edibits_dataɂ͂炩ߕKvȃTCYmۂĂȂƂȂB
 *  KvȃTCYgetOutputSize()Ŏ擾ł
 */
CResult CDIBitsConverter::convert( void* dibits_data )
{
	CResult result;
	if( _allocate_bits != 8 && _allocate_bits != 16 ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CDIBitsConverterallocate_bits8,16ȊÕf[^̓T|[gĂ܂" );
		return result;
	}

	if( _samples_per_pixel != 1 && _samples_per_pixel != 3 ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CDIBitsConvertersamples_per_pixel1,3ȊÕf[^̓T|[gĂ܂" );
		return result;
	}

	if( _allocate_bits == 16 && _samples_per_pixel == 3 ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CDIBitsConvertersamples_per_pixel3allocate_bits16̃f[^̓T|[gĂ܂" );
		return result;
	}

	// rbg}bvf[^XByteTCY擾
	int align_column = ( _row > 0 )? getOutputSize() / _row: 0;


	if( _samples_per_pixel == 3 ){
		// J[f[^rbg}bvf[^ɕϊ
		unsigned char* src;
		unsigned char* dst;
		
		for( int i=0; i < _row; i++ ){
			src = _src_data + _column * _samples_per_pixel * i;
			dst = (unsigned char*)dibits_data + align_column * ( _row - 1 - i );
			for( int j=0; j < _column; j++ ){
				dst[j*3]   = convert_grayscale( src[j*3]   );
				dst[j*3+1] = convert_grayscale( src[j*3+1] );
				dst[j*3+2] = convert_grayscale( src[j*3+2] );
			}
		}
	} else if( _allocate_bits == 8 ){
		// mN8bitf[^rbg}bvf[^ɕϊ

		if( _representation ){ // t
			char* src;
			unsigned char* dst;
			
			for( int i=0; i < _row; i++ ){
				src = (char*)_src_data + _column * i;
				dst = (unsigned char*)dibits_data + align_column * ( _row - 1 - i );
				for( int j=0; j < _column; j++ ){
					dst[j*3]   = dst[j*3+1] = dst[j*3+2] = convert_grayscale( src[j] );
				}
			}
		} else { // 
			unsigned char* src;
			unsigned char* dst;
			
			for( int i=0; i < _row; i++ ){
				src = _src_data + _column * i;
				dst = (unsigned char*)dibits_data + align_column * ( _row - 1 - i );
				for( int j=0; j < _column; j++ ){
					dst[j*3]   = dst[j*3+1] = dst[j*3+2] = convert_grayscale( src[j] );
				}
			}
		}
	} else {
		// mN16bitf[^rbg}bvf[^ɕϊ

		if( _representation ){ // t
			short* src;
			unsigned char* dst;
			
			for( int i=0; i < _row; i++ ){
				src = (short*)_src_data + _column * i;
				dst = (unsigned char*)dibits_data + align_column * ( _row - 1 - i );
				for( int j=0; j < _column; j++ ){
					dst[j*3]   = dst[j*3+1] = dst[j*3+2] = convert_grayscale( src[j] );
				}
			}
		} else { // 
			unsigned short* src;
			unsigned char* dst;
			
			for( int i=0; i < _row; i++ ){
				src = (unsigned short*)_src_data + _column * i;
				dst = (unsigned char*)dibits_data + align_column * ( _row - 1 - i );
				for( int j=0; j < _column; j++ ){
					dst[j*3]   = dst[j*3+1] = dst[j*3+2] = convert_grayscale( src[j] );
				}
			}
		}
	}

	result.SetCode( RESULT_GOOD );
	return result;
}

/** DICOMf[^̉flKϊ
 *
 */
unsigned char CDIBitsConverter::convert_grayscale( int src )
{
	// Kϊe[u쐬
	create_table();

	// 臒l͈͓̔H
	if( is_too_dark( src ) == true ) return 0;
	if( is_too_light( src ) == true ) return 255;

	// Kϊe[u̒lԂ
	return _table[ src - _table_min ];
}

/** Kϊe[u쐬
 *
 */
void CDIBitsConverter::create_table()
{
	if( _table_center == _center &&
	    _table_width == _width &&
		_table_reverse == _reverse ){
		return;
	}

	_table_center = _center;
	_table_width = _width;
	_table_reverse = _reverse;

	// e[uTCYK̕傫΁Ag
	if( _width + 1 > _table_size ){
		delete [] _table;
		_table_size = _width + 1;
		_table = new unsigned char[_table_size];
	}

	// K΁A0Ԃ悤ȃe[u
	if( _width <= 0 ){
		_table[0] = 0;
		_table_min = 0;
		_table_max = 0;
		return;
	}

	_table_min = _table_center - _table_width / 2;
	_table_max = _table_center + _table_width / 2;

	// e[u0`255܂ł̐l
	if( _reverse == true ){
		for( int i=0; i <= _table_width; i++ ){
			_table[i] = (unsigned char)( 255 - 255 * i / _table_width );
		}
	} else {
		for( int i=0; i <= _table_width; i++ ){
			_table[i] = (unsigned char)( 255 * i / _table_width );
		}
	}
}


/** Kϊe[u̍F𒴂ĂȂH
 *
 */
bool CDIBitsConverter::is_too_dark( int value )
{
	if( _reverse == true ){
		if( value > _table_max ){
			return true;
		}
	} else {

		if( value < _table_min ){
			return true;
		}
	}

	return false;
}

/** Kϊe[u̔F𒴂ĂȂH
 *
 */
bool CDIBitsConverter::is_too_light( int value )
{
	if( _reverse == true ){
		if( value < _table_min ){
			return true;
		}
	} else {
		if( value > _table_max ){
			return true;
		}
	}

	return false;
}

// Qb^[
int CDIBitsConverter::getColumn(){ return _column; }
int CDIBitsConverter::getRow(){ return _row; }
int CDIBitsConverter::getWindowWidth(){ return _width; }
int CDIBitsConverter::getWindowCenter(){ return _center; }
bool CDIBitsConverter::getWindowReverse(){ return _reverse; }
int CDIBitsConverter::getStoredBits(){ return _stored_bits; }
bool CDIBitsConverter::getRepresentation(){ return _representation; }