/** CListBuilder
 *
 *  @file   DIBitsConverter.h
 *  @author Y.Kameda
 *  @date   2003/7/12
 *
 */

#if !defined(AFX_DIBITSCONVERTER_H__95B0D6E3_B4FD_4294_A15B_6E4C0E73056D__INCLUDED_)
#define AFX_DIBITSCONVERTER_H__95B0D6E3_B4FD_4294_A15B_6E4C0E73056D__INCLUDED_

#include "result.h"

namespace dcl{

/** 1̉摜24bitrbg}bvf[^ɕϊ
 *
 */
class CDIBitsConverter  
{
public:
	CDIBitsConverter();
	~CDIBitsConverter();

	// f[^Zbg
	// Eallocate_bits816łȂƂȂ
	// Esamples_per_pixel13łȂƂȂ
	void setData( const void* src_data, int column, int row, int allocate_bits, int stored_bits, int samples_per_pixel, bool representation );

	// KZbg
	void setWindow( int center, int width, bool reverse );

	// convert̏o͂ɕKvȃTCYԂ
	int getOutputSize();


	// 24bitrbg}bvf[^o͂
	// Edibits_dataɂ͂炩ߕKvȃoCgmۂĂȂƂȂB
	//  KvȃoCggetOutputSize()Ŏ擾ł
	CResult convert( void* dibits_data );

	// Qb^[
	int getColumn();
	int getRow();
	int getWindowWidth();
	int getWindowCenter();
	bool getWindowReverse();
	int getStoredBits();
	bool getRepresentation();

private:
	// Kϊs
	inline unsigned char convert_grayscale( int );

	// Kϊe[u
	inline void create_table();

	// e[u̍F𒴂ĂȂH
	inline bool is_too_dark( int value );

	// e[u̔F𒴂ĂȂH
	inline bool is_too_light( int value );

private:
	unsigned char* _src_data;
	int _column;
	int _row;
	int _allocate_bits;
	int _stored_bits;
	int _center;
	int _width;
	int _samples_per_pixel;
	bool _reverse;
	bool _representation;

	// Kϊe[u
	unsigned char* _table;
	int _table_min;
	int _table_max;
	int _table_size;

	int _table_center;
	int _table_width;
	bool _table_reverse;
};

}

#endif // !defined(AFX_DIBITSCONVERTER_H__95B0D6E3_B4FD_4294_A15B_6E4C0E73056D__INCLUDED_)
