/** CFilePerserNX
 *
 *  @file FilePerser.h
 *  @author Y.Kameda
 *  @date 2003/4/23
 *
 */

#ifndef INCLUDE_FILE_PERSER_H
#define INCLUDE_FILE_PERSER_H

#define TRANSFERLITTLEENDIAN_UID						"1.2.840.10008.1.2"
#define TRANSFERLITTLEENDIANEXPLICIT_UID				"1.2.840.10008.1.2.1"
#define TRANSFERBIGENDIANEXPLICIT_UID					"1.2.840.10008.1.2.2"
#define TRANSFERJPEGBASELINEPROCESS1_UID				"1.2.840.10008.1.2.4.50"
#define TRANSFERJPEGEXTENDEDPROC2AND4_UID				"1.2.840.10008.1.2.4.51"
#define TRANSFERJPEGEXTENDEDPROC3AND5_UID				"1.2.840.10008.1.2.4.52"
#define TRANSFERJPEGSPECTRALPROC6AND8_UID				"1.2.840.10008.1.2.4.53"
#define TRANSFERJPEGSPECTRALPROC7AND9_UID				"1.2.840.10008.1.2.4.54"
#define TRANSFERJPEGFULLPROGRESSPROC10AND12_UID			"1.2.840.10008.1.2.4.55"
#define TRANSFERJPEGFULLPROGRESSPROC11AND13_UID			"1.2.840.10008.1.2.4.56"
#define TRANSFERJPEGLOSSLESSPROC14_UID					"1.2.840.10008.1.2.4.57"
#define TRANSFERJPEGLOSSLESSPROC15_UID					"1.2.840.10008.1.2.4.58"
#define TRANSFERJPEGEXTENDEDPROC16AND18_UID				"1.2.840.10008.1.2.4.59"
#define TRANSFERJPEGEXTENDEDPROC17AND19_UID				"1.2.840.10008.1.2.4.60"
#define TRANSFERJPEGSPECTRALPROC20AND22_UID				"1.2.840.10008.1.2.4.61"
#define TRANSFERJPEGSPECTRALPROC21AND23_UID				"1.2.840.10008.1.2.4.62"
#define TRANSFERJPEGFULLPROGRESSPROC24AND26_UID			"1.2.840.10008.1.2.4.63"
#define TRANSFERJPEGFULLPROGRESSPROC25AND27_UID			"1.2.840.10008.1.2.4.64"
#define TRANSFERJPEGLOSSLESSPROC28_UID					"1.2.840.10008.1.2.4.65"
#define TRANSFERJPEGLOSSLESSPROC29_UID					"1.2.840.10008.1.2.4.66"
#define TRANSFERJPEGLOSSLESSPROCFIRSTORDERREDICT_UID	"1.2.840.10008.1.2.4.70"

enum TRANSFER_SYNTAX_TYPE{
	IMPLICIT_LITTLE,
	EXPLICIT_LITTLE
};

#include "Perser.h"

namespace dcl{

/** CFilePerserNX
 *
 *  DICOMt@Cǂݍނ߂CPerserhNXB
 *
 */
class CFilePerser :public CPerser
{
	/** CFilePerser::CState
	 *
	 *  DICOMt@Cǂݍݏ󋵃NX
	 */
	class CState{
	private:
		int m_state;
	public:
		CState():m_state(0){};
		bool isStart()  {if(m_state==0)return true; else return false;} // ŏ
		bool isPrefix() {if(m_state==1)return true; else return false;} // DICMvtBbNX
		bool isElement(){if(m_state==2)return true; else return false;} // ̓^Oi̗\j

		void SetPrefixState(){m_state=1;}  // vtBbNX̎Ăяo
		void SetElementState(){m_state=2;} // ^O̎AĂяo
	};

	CState m_state;
	FILE* m_file;
	unsigned long m_current_pos;
	TRANSFER_SYNTAX_TYPE m_transfer_syntax;
public:
	CFilePerser();
	virtual ~CFilePerser();
	virtual  CResult GetNext( const CToken** ); ///< ̃g[Nǂݍ

	CResult Open( const char* file_path );
	CResult Close(); ///< t@C

	CResult ReadVRLenImplicitLittle( unsigned short group, unsigned short element, unsigned char* p_vrlen, VR_TYPE& vr, int& data_len );
	CResult ReadVRLenExplicitLittle( unsigned short group, unsigned short element, unsigned char* p_vrlen, FILE* file, unsigned long& current_pos, VR_TYPE& vr, int& data_len );
};

}

#endif
