#include "ListBuilder.h"

using namespace dcl;

CListBuilder::CListBuilder()
{
	// ʃV[PX쐬
	m_sequence = new CElement( ELEMENT_START_DELIMITER );
	m_sequence->m_next   = new CElement( ELEMENT_END_DELIMITER );
	m_sequence->m_next->m_prev = m_sequence;
}

CListBuilder::~CListBuilder()
{
	delete m_sequence;
}

CElement* CListBuilder::GetSequence()
{
	return m_sequence;
}


CResult CListBuilder::Load()
{
	delete m_sequence;
	m_sequence = new CElement( ELEMENT_START_DELIMITER );
	m_sequence->m_next   = new CElement( ELEMENT_END_DELIMITER );
	m_sequence->m_next->m_prev = m_sequence;

	CResult result;
	CPerser* perser = GetPerser();
	if( perser == NULL ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CPerserBindĂȂ" );
		return result;
	}

	CElement* sequence = GetSequence();

	// ^Oǂݍ
	return LoadSequence( sequence, perser, -1 );
}

/** 1̃V[PXI܂œǂݍ
 *
 */
CResult CListBuilder::LoadSequence( CElement* sequence, CPerser* perser, int length )
{
	CResult result;
	const CToken* token;
	int l = 0;
	int     i;

	while( 1 ){

		// V[PXǂݏIǂݍݏI(V[PX==-1ȂAIf~^邩At@C̏I܂œǂݍ)
		if( l >= length && length >= 0 ){
			goto BREAK;
		}

		result = perser->GetNext( &token );
		if( result.Failed() ){
			return result;
		}

		switch( token->GetType() ){
		case TOKEN_PREAMBLE: // t@CvAu
			//puts( "[t@CvAu]" );
			break;
		case TOKEN_DICM:     /// DICMvtBbNX
			//puts( "[DICMvtBbNX]" );
			break;
		case TOKEN_ELEMENT:  /// ^Ovf

			if( token->GetGroup() == 0xfffe && token->GetElement() == 0xe00d ){ // V[PXIf~^H
				goto BREAK;
			}

			result = sequence->AddElement( token->GetGroup(), token->GetElement(), token->GetData(), token->GetLength(), token->GetVR() );
			if( result.Failed() ){
				return result;
			}

			if( token->GetVR() == VR_SQ || token->GetVR() == VR_OB || token->GetVR() == VR_OW ){
				CElement* e = sequence->SearchElement( token->GetGroup(), token->GetElement() );
				if( !e ){
					result.SetCode( RESULT_FAILED );
					result.AddMessage( "CElement::SearchElement()Ɏs" );
					return result;
				}

				if( token->GetVR() == VR_SQ ){
					// V[PX^O̒gǂݍ
					result = LoadSequences( e, perser );
					if( result.Failed() ){
						return result;
					}
				} else if( token->GetLength() == -1 ){
				// OBAOWŃJvZ\̂Ƃ
					// V[PX\쐬
					result = sequence->InsertSequence( 0 );
					if( result.Failed() ){
						return result;
					}

					// 쐬V[PX擾
					CElement* e = sequence->GetSequence( 0 );
					if( !e ){
						result.SetCode( RESULT_FAILED );
						result.AddMessage( "CElement::zGetSequence()Ɏs" );
						return result;
					}

					result = LoadSequence( e, perser, -1 );
				}
			}
			break;

		case TOKEN_BLOKEN:   /// ^ȎOɃt@CI[Ă܂BtH[}bgG[
			puts( "[ꂽ^O]" );
			printf( "(%04x,%04x) [%d] %8d(%8d)  ", token->GetGroup(), token->GetElement(), token->GetVR(), token->GetFailLength(), token->GetLength() );
			for( i=0; i < _MIN( token->GetLength(), 8 ); i++ ){
				printf( "%02x ", token->GetData()[i] );
			}
			puts( "" );
			break;
		case TOKEN_END_POS:
			goto BREAK;
		}
	}

BREAK:
	result.SetCode( RESULT_GOOD );
	return result;
}

/** V[PX̏W܂ǂݍ
 *
 */
CResult CListBuilder::LoadSequences( CElement* parent, CPerser* perser )
{
	CResult result;
	const CToken* token;
	int count = 0;
	int i;

	while( 1 ){

		result = perser->GetNext( &token );
		if( result.Failed() ){
			return result;
		}

		switch( token->GetType() ){
		case TOKEN_ELEMENT:  /// ^Ovf

			if( token->GetGroup() == 0xfffe && token->GetElement() == 0xe0dd ){ // V[PXIf~^H
				goto BREAK;
			}

			if( token->GetGroup() == 0xfffe && token->GetElement() == 0xe000 ){ // V[PXJnf~^H
				// V[PX\쐬
				result = parent->InsertSequence( count );
				if( result.Failed() ){
					return result;
				}

				// 쐬V[PX擾
				CElement* e = parent->GetSequence( count );
				if( !e ){
					result.SetCode( RESULT_FAILED );
					result.AddMessage( "CElement::zGetSequence()Ɏs" );
					return result;
				}

				result = LoadSequence( e, perser, token->GetLength() );
				count++;
				break;
			}

			// f~^ȊÕ^OƁAG[
			result.SetCode( RESULT_FAILED );
			result.AddMessage( "V[PX^O̊Jnf~^܂" );
			return result;

		case TOKEN_BLOKEN:   /// ^ȎOɃt@CI[Ă܂BtH[}bgG[
			puts( "[ꂽ^O]" );
			printf( "(%04x,%04x) [%d] %8d(%8d)  ", token->GetGroup(), token->GetElement(), token->GetVR(), token->GetFailLength(), token->GetLength() );
			for( i=0; i < _MIN( token->GetLength(), 8 ); i++ ){
				printf( "%02x ", token->GetData()[i] );
			}
			puts( "" );
			break;
		case TOKEN_END_POS:
			goto BREAK;
		}
	}

BREAK:
	result.SetCode( RESULT_GOOD );
	return result;
}





ELEMENT_TYPE     CElement::GetType() const       /// f[^ނԂ
{
	return m_type;
}

unsigned short CElement::GetGroup() const      /// O[vԍԂ
{
	return m_group;
}

unsigned short CElement::GetElement() const    /// GgԍԂ
{
	return m_element;
}

VR_TYPE        CElement::GetVR() const
{
	return m_vr;
}

int            CElement::GetLength() const     /// f[^
{
	return m_length;
}

const unsigned char* CElement::GetData() const /// f[^ւ̃|C^BNULL͕ԂȂB
{
	return m_data;
}

void CElement::SetData( const unsigned char* data, int length)
{
	delete [] m_data;
	m_data = new unsigned char[_MAX(length+1,1)];
	m_data[length] = 0;

	if( data ){
		memcpy( m_data, data, _MAX(length,0) );
	}
	m_length = length;
}

int CElement::CountSequence()
{
	return m_sequence.size();
}

CElement* CElement::GetSequence( int index )
{
	if( index < 0 || index >= m_sequence.size() ) return NULL;

	return m_sequence[index];
}

CResult CElement::InsertSequence( int index )
{
	CResult result;

	if( index < 0 || index > m_sequence.size() ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CfbNXԍsKł" );
		return result;
	}

	// ʃV[PX쐬
	CElement* new_sequence = new CElement( ELEMENT_START_DELIMITER );
	new_sequence->m_next = new CElement( ELEMENT_END_DELIMITER );
	new_sequence->m_next->m_prev = new_sequence;

	// ʃV[PXXgɁA쐬V[PXǉ
	vector<CElement*>::iterator it = m_sequence.begin();
	it += index + 1;
	m_sequence.insert( it, new_sequence );

	result.SetCode( RESULT_GOOD );
	return result;
}

CResult CElement::RemoveSequence( int index )
{
	CResult result;

	if( index < 0 || index >= m_sequence.size() ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CfbNXԍsKł" );
		return result;
	}

	CElement* element = m_sequence[index];
	delete element;

	// V[PXXgindexvf폜
	vector<CElement*>::iterator it = m_sequence.begin();
	it += index;
	m_sequence.erase( it );

	result.SetCode( RESULT_GOOD );
	return result;
}


// ړ
CElement* CElement::GetNext()
{
	return m_next;
}

CElement* CElement::GetPrev()
{
	return m_prev;
}


CElement::CElement( ELEMENT_TYPE type )
{
	m_type = type;

	m_group = m_element = 0;
	m_vr = VR_UN;
	m_length = 0;
	m_data = new unsigned char[1];
	m_data[0] = 0;

	m_next = m_prev = NULL;
}

CElement::~CElement()
{
	// ʃV[PXXg폜
	while( m_sequence.size() > 0 ){
		RemoveSequence( 0 );
	}

	// 擪vfȂÃV[PX폜
	if( m_type == ELEMENT_START_DELIMITER ){
		CElement* element = m_next;
		CElement* next;

		// ʃV[PX̑Svf폜
		while( element ){
			next = element->m_next;
			delete element;
			element = next;
		}
	}

	// f[^폜
	delete [] m_data;
}

/** vfV[PXɗvfǉ
 *
 *  V[PX̐擪vf(m_typeELEMENT_START_DELIMITER)sBȊORESULT_FAILEDԂB
 */
CResult CElement::AddElement( unsigned short group, unsigned short element, const unsigned char* data, int length )
{
	CResult result;

	if( m_type != ELEMENT_START_DELIMITER ){
		result.AddMessage( "V[PX̐擪vfł͂܂" );
		result.SetCode( RESULT_FAILED );
	}

	// YvfB΍
	CElement* e = CreateElement( GetNext(), group, element );
	if( !e ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "dȃG[BCElement::CreateElement()ŁAV[PXIvf܂łB" );
		return result;
	}

	// f[^AVRZbg
	e->SetData( data, length );

	// VRāAZbg
	string caption;
	e->m_vr = GetStandardDictionary()->ConsultVR( group, element, caption );

	result.SetCode( RESULT_GOOD );
	return result;
}

/** vfV[PXɗvfǉ
 *
 *  V[PX̐擪vf(m_typeELEMENT_START_DELIMITER)sBȊORESULT_FAILEDԂB
 */
CResult CElement::AddElement( unsigned short group, unsigned short element, const unsigned char* data, int length, VR_TYPE vr )
{
	CResult result;

	if( m_type != ELEMENT_START_DELIMITER ){
		result.AddMessage( "V[PX̐擪vfł͂܂" );
		result.SetCode( RESULT_FAILED );
	}

	// YvfB΍
	CElement* e = CreateElement( GetNext(), group, element );
	if( !e ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "dȃG[BCElement::CreateElement()ŁAV[PXIvf܂łB" );
		return result;
	}

	// f[^AVRZbg
	e->SetData( data, length );
	e->m_vr = vr;

	result.SetCode( RESULT_GOOD );
	return result;
}


/** YvfB΍
 *
 */
CElement* CElement::CreateElement( CElement* e, unsigned short group, unsigned short element )
{
	while( e ){
		// O[vAGgv邩H
		if( e->GetType() == ELEMENT_NORMAL ){
			if( e->GetGroup() == group && e->GetElement() == element ){
				return e;
			}
		}

		// O[vAGgvvf܂H
		if( e->GetType() == ELEMENT_END_DELIMITER ||
			e->GetGroup() > group ||
			( e->GetGroup() == group && e->GetElement() == element ) ){

			// VvfAf[^Zbg
			CElement* new_e = new CElement( ELEMENT_NORMAL );

			// VvfvfV[PXɑ}
			CElement* prev = e->m_prev;
			prev->m_next  = new_e;
			e->m_prev     = new_e;
			new_e->m_prev = prev;
			new_e->m_next = e;

			new_e->m_group   = group;
			new_e->m_element = element;

			return new_e;
		}

		e = e->GetNext();
	}

	return NULL;
}

/** YvfB
 *
 */
CElement* CElement::SearchElement( unsigned short group, unsigned short element )
{
	//if( m_type != ELEMENT_START_DELIMITER ){
	//	result.AddMessage( "V[PX̐擪vfł͂܂" );
	//	result.SetCode( RESULT_FAILED );
	//}

	CElement* e = this;

	while( e ){
		
		// I[f~^H
		if( e->GetType() == ELEMENT_END_DELIMITER  ){
			break;
		}

		// O[vAGgv邩H
		if( e->GetType() == ELEMENT_NORMAL ){

			if( e->GetGroup() == group && e->GetElement() == element ){
				return e;
			}
		}

		e = e->GetNext();
	}

	return NULL;
}
