/** CTokenNX
 *
 *  @file Token.cpp
 *  @author Y.Kameda
 *  @date 2003/4/23
 *
 */

#include "Token.h"
#include <memory.h>
#include <string>

using namespace std;
using namespace dcl;

CToken::CToken()
: m_type(TOKEN_END_POS), m_vr(VR_UN)
{
	m_group   = m_element = 0;
	m_length  = m_fail_length = 0;
	m_data    = new unsigned char[1];
	m_tag_pos = m_data_pos = 0;
}

void CToken::Clear()
{
	m_type    = TOKEN_END_POS;
	m_vr      = VR_UN;
	m_group   = m_element = 0;
	m_length  = m_fail_length = 0;
	delete [] m_data;
	m_data    = new unsigned char[1];
	m_tag_pos = m_data_pos = 0;
	
}

CToken::~CToken()
{
	delete [] m_data;
}

TOKEN_TYPE     CToken::GetType() const       /// f[^ނԂ
{
	return m_type;
}

unsigned short CToken::GetGroup() const      /// O[vԍԂ
{
	return m_group;
}

unsigned short CToken::GetElement() const    /// GgԍԂ
{
	return m_element;
}

VR_TYPE        CToken::GetVR() const         /// 3ByteڂNULL~߂ꂽVRԂB
{
	return m_vr;
}

int            CToken::GetFailLength() const /// TYPE_BLOKEN̎̂ݗLB^ÕOXɃZbgĂlB
{
	return m_fail_length;
}

int            CToken::GetLength() const     /// f[^
{
	return m_length;
}

const unsigned char* CToken::GetData() const /// f[^ւ̃|C^BNULL͕ԂȂB
{
	return m_data;
}

unsigned long  CToken::GetTagPos() const     /// ^O̐擪̃ItZbg
{
	return m_tag_pos;
}

unsigned long  CToken::GetDataPos() const    /// f[^̐擪̃ItZbg
{
	return m_data_pos;
}


void CToken::SetType( TOKEN_TYPE type )       /// f[^ނԂ
{
	m_type = type;
}

void CToken::SetGroup( unsigned short g )      /// O[vԍԂ
{
	m_group = g;
}

void CToken::SetElement( unsigned short e )    /// GgԍԂ
{
	m_element = e;
}

void CToken::SetVR( VR_TYPE vr )         /// 3ByteڂNULL~߂ꂽVRԂB
{
	m_vr = vr;
}

void CToken::SetFailLength( int len ) /// TYPE_BLOKEN̎̂ݗLB^ÕOXɃZbgĂlB
{
	m_fail_length = len;
}

void CToken::SetTagPos( unsigned long pos )     /// ^O̐擪̃ItZbg
{
	m_tag_pos = pos;
}

void CToken::SetDataPos( unsigned long pos )    /// f[^̐擪̃ItZbg
{
	m_data_pos = pos;
}

void CToken::SetData( const unsigned char* data, int length) /// f[^ւ̃|C^BNULL͕ԂȂB
{
	delete [] m_data;
	m_data = new unsigned char[_MAX(length,0)];
	memcpy( m_data, data, _MAX(length,0) );
	m_length = length;
}

string dcl::Vr2Str( VR_TYPE vr )
{
	switch( vr ){
	case VR_AE : return "AE";
	case VR_AS : return "AS";
	case VR_AT : return "AT";
	case VR_CS : return "CS";
	case VR_DA : return "DA";
	case VR_DS : return "DS";
	case VR_DT : return "DT";
	case VR_FL : return "FL";
	case VR_FD : return "FD";
	case VR_IS : return "IS";
	case VR_LO : return "LO";
	case VR_LT : return "LT";
	case VR_OB : return "OB";
	case VR_OW : return "OW";
	case VR_PN : return "PN";
	case VR_SH : return "SH";
	case VR_SL : return "SL";
	case VR_SQ : return "SQ";
	case VR_SS : return "SS";
	case VR_ST : return "ST";
	case VR_TM : return "TM";
	case VR_UI : return "UI";
	case VR_UL : return "UL";
	case VR_US : return "US";
	case VR_UT : return "UT";
	case VR_UN :
	case VR_OTHER:
	default    : return "UN";
	}
}