/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.misc.XtraceStream;

public class ShFunction implements ShTree {

	private String name;
	private ShTree tree;

	public ShFunction(String name, ShTree tree) {
		this.name = name;
		this.tree = tree;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

	public int eval(ShEnvironment env, ShFileSystem fs,
			ShBuiltInCommands cmds, ShRuntime run, InputStream in,
			PrintStream out, PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		env.bind(name, ShTrees.compile(tree));
		return 0;
	}

	public String toString() {
		return name + " ()\n" + tree;
	}

}
