/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.misc;

public final class ShUtils {

	public static double normalRandom() {
		double x, y, theta, r;

		x = Math.random();  y = Math.random();
		theta = 2 * Math.PI * y;
		r = Math.sqrt(-2 * Math.log(x));
		return r * Math.cos(theta);
	}

	public static double normalRandom(double mean, double sd) {
		double x = normalRandom();

		x = sd * x + mean;
		return x;
	}

	public static int normalRandomUnsignedShort(double mean,
			double sd) {
		double x;

		while((x = normalRandom(mean, sd)) < 0 || x >= 1.0);
		return (int)(65536 * x);
	}

}
