/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.translate;

import java.util.Arrays;
import java.util.List;

public class DecultureSemanticsException extends RuntimeException {

	//
	private List<Object> args;

	/**
	 * 
	 * @param message
	 * @param line
	 */
	public DecultureSemanticsException(String message, Object... args) {
		super(message);
		this.args = Arrays.asList(args);
	}

	/**
	 * 
	 * @return
	 */
	public Object[] getArgs() {
		return args.toArray(new Object[0]);
	}

}
