/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.handler;

import com.ranfa.lib.CheckVersion;
import com.ranfa.lib.handler.CrashReportList;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrashHandler {
    private final Logger LOG = LoggerFactory.getLogger(CrashHandler.class);
    private Throwable e;
    private String description;
    private int estimateExitCode;
    private CrashReportList<String> crashReportLines = new CrashReportList();
    private static Random random = new Random(System.currentTimeMillis());
    private static final String DEFAULT_DESCRIPTION = "Unexpected Error";
    private static final String[] EASTER_LINES = new String[]{"// It will need to do more test?", "// I may be so bad to code?", "// Shimamura Uzuki, I'll do my best!", "// This is also adventure!, isn't it?", "// I... left all books... behind... 'cause I want to talk... with you...", "// This software was developed by @hizumiaoba", "// These Easter sentences were inspired by Minecraft Crash Report!"};
    private static final int EXIT_WITH_NESTED_CAUSE = 2;
    private static final int EXIT_WITH_NULL_POINTER_EXCEPTION = 3;
    private static final int EXIT_WITH_ILLEGAL_STATE_EXCEPTION = 5;
    private static final int EXIT_WITH_COMPLETION_EXCEPTION = 7;
    private static final int EXIT_WITH_ILLEGAL_ARGUMENT_EXCEPTION = 9;

    public CrashHandler() {
        this(DEFAULT_DESCRIPTION);
    }

    public CrashHandler(String m) {
        this(m, null);
    }

    public CrashHandler(Throwable e) {
        this(DEFAULT_DESCRIPTION, e);
    }

    public CrashHandler(String description, Throwable e) {
        this.LOG.warn("Unexpected Exception has occured. : {}", (Object)(e == null ? "null" : e.toString()));
        this.LOG.warn("Provided Detail Message : {}", (Object)description);
        this.e = e;
        this.description = description;
        this.estimateExitCode = Integer.MIN_VALUE;
        this.crashReportLines.add("---- DelesteRandomSelector Crash Report ----");
        int randomInt = random.nextInt(EASTER_LINES.length);
        this.crashReportLines.add(EASTER_LINES[randomInt]);
    }

    public void execute() {
        if (this.e == null) {
            throw new NullPointerException("Cannot execute crash because throwable is null.");
        }
        this.estimateExitCode = this.calcExitCode();
        this.LOG.error("Cannot keep up application! : {}", (Object)this.e.toString());
        this.LOG.error("Application will exit with exit code : {}", (Object)this.estimateExitCode);
        this.LOG.error(this.outputReport());
        this.crashReportLines.outCrashReport();
        System.exit(this.estimateExitCode);
    }

    private String outputReport() {
        this.crashReportLines.emptyLine();
        SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd HH:mm");
        this.crashReportLines.add("Time: " + format.format(new Date()));
        this.crashReportLines.add("Description: " + this.description);
        this.crashReportLines.emptyLine();
        this.LOG.debug("Gathering exception informations.");
        if (this.e != null) {
            this.crashReportLines.add("These are simplified stack trace. (shown up to 5 lines. Full Stack trace is below.)");
            this.crashReportLines.add(this.e.toString());
            StackTraceElement[] topElements = this.e.getStackTrace();
            int i = 0;
            while (i < 5) {
                this.crashReportLines.add("\tat " + topElements[i].toString());
                ++i;
            }
            this.crashReportLines.emptyLine();
            this.crashReportLines.add("A detailed walkthrough of the error, its code path and all known details is as follows:");
            this.crashReportLines.add("---------------------------------------------------------------------------------------");
            this.crashReportLines.emptyLine();
            this.crashReportLines.add("Stacktrace:");
            this.crashReportLines.add(this.e.getMessage());
            CrashHandler.addLinesRecursively(this.e, this.crashReportLines);
        }
        this.LOG.debug("Gathering system informations.");
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean operatingBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryBean.getHeapMemoryUsage();
        this.crashReportLines.emptyLine();
        this.crashReportLines.add("-- System Details --");
        this.crashReportLines.add("Details:");
        this.crashReportLines.add("\tDelesteRandomSelector Version: " + CheckVersion.getVersion());
        this.crashReportLines.add("\tOperating System: " + operatingBean.getName() + " (" + operatingBean.getArch() + ") version " + operatingBean.getVersion());
        this.crashReportLines.add("\tJava Version: " + runtimeBean.getSpecVersion() + ", " + runtimeBean.getVmVendor());
        this.crashReportLines.add("\tJava VM Version: " + runtimeBean.getVmName() + ", version " + runtimeBean.getVmVersion());
        this.crashReportLines.add("\tMemory: " + memUsage.getUsed() + " bytes / " + memUsage.getInit() + " bytes up to " + memUsage.getMax() + " bytes");
        this.crashReportLines.add("\tJVM Flags: " + runtimeBean.getInputArguments().size() + " total: " + runtimeBean.getInputArguments().toString());
        return this.crashReportLines.generateCrashReport();
    }

    public String outSystemInfo() {
        this.e = null;
        this.description = "Loading screen debug info\n\nThis is just a prompt for computer specs to be printed. THIS IS NOT A ERROR";
        String res = this.outputReport();
        this.LOG.info(res);
        return res;
    }

    public static CrashReportList<String> addLinesRecursively(Throwable e, CrashReportList<String> list) {
        StackTraceElement[] elements;
        if (e == null) {
            return list;
        }
        StackTraceElement[] stackTraceElementArray = elements = e.getStackTrace();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            list.add("\tat " + element.toString());
            ++n2;
        }
        if (e.getCause() != null) {
            list.add("Caused by: " + e.getCause().toString());
            CrashHandler.addLinesRecursively(e.getCause(), list);
        }
        return list;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Throwable getThrowable() {
        return this.e;
    }

    public void setCause(Throwable e) {
        this.e = e;
    }

    public int getEstimateExitCode() {
        return this.estimateExitCode;
    }

    private int calcExitCode() {
        int res = 1;
        if (this.e.getCause() != null) {
            res *= 2;
        }
        if (this.e instanceof NullPointerException) {
            res *= 3;
        }
        if (this.e instanceof IllegalStateException) {
            res *= 5;
        }
        if (this.e instanceof CompletionException) {
            res *= 7;
        }
        if (this.e instanceof IllegalArgumentException) {
            res *= 9;
        }
        if (this.e.getCause() != null) {
            return CrashHandler.calcExitCode(this.e.getCause(), res);
        }
        return res;
    }

    private static int calcExitCode(Throwable e, int current) {
        if (e == null) {
            return current;
        }
        if (e.getCause() != null) {
            current *= 2;
        }
        if (e instanceof NullPointerException) {
            current *= 3;
        }
        if (e instanceof IllegalStateException) {
            current *= 5;
        }
        if (e instanceof CompletionException) {
            current *= 7;
        }
        if (e instanceof IllegalArgumentException) {
            current *= 9;
        }
        return CrashHandler.calcExitCode(e.getCause(), current);
    }
}

