/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.handler;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public class CrashReportList<E>
extends ArrayList<E> {
    private static final String EMPTY_LINE_PLACEHOLDER = "{empty}";
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private List<E> store = new ArrayList();

    @Override
    public boolean add(E e) {
        return this.store.add(e);
    }

    public String generateCrashReport() {
        StringBuilder builder = new StringBuilder();
        for (Object str : this.store) {
            if (str.equals(EMPTY_LINE_PLACEHOLDER)) {
                str = "\n";
            }
            builder.append(str).append("\n");
        }
        return builder.toString();
    }

    public boolean emptyLine() {
        return this.store.add(EMPTY_LINE_PLACEHOLDER);
    }

    public void outCrashReport() {
        try {
            if (Files.notExists(Paths.get("Crash-Report", new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get("Crash-Report", new String[0]), new FileAttribute[0]);
            }
            FileWriter writer = new FileWriter(Paths.get("Crash-Report/" + this.FORMAT.format(new Date()) + ".txt", new String[0]).toFile());
            writer.write(this.generateCrashReport());
            writer.close();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(CrashReportList.class).error("Cannot write crash report.", (Throwable)e);
        }
    }
}

