/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.songinfo;

import HajimeAPI4J.api.HajimeAPI4J;
import HajimeAPI4J.api.HajimeAPIBuilder;
import HajimeAPI4J.api.util.HajimeAPI4JImpl;
import HajimeAPI4J.api.util.datatype.Member;
import HajimeAPI4J.exception.NoSuchURIException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ranfa.lib.concurrent.CountedThreadFactory;
import com.ranfa.main.DelesteRandomSelector;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchFromAPI {
    private Logger logger = LoggerFactory.getLogger(FetchFromAPI.class);
    private ExecutorService localDispatcher = Executors.newCachedThreadPool(new CountedThreadFactory(() -> "DRS", "LocalDispatcher"));
    private List<JsonNode> nodes;

    public FetchFromAPI(String ... songnames) {
        ArrayList<JsonNode> listFutures = new ArrayList<JsonNode>();
        AtomicInteger n = new AtomicInteger(0);
        for (String songname : Arrays.asList(songnames)) {
            DelesteRandomSelector.labelInfoProgressSongName.setText("<html><body>Processing : " + songname + "</body></html>");
            Map<String, Object> data = this.fetchList(songname);
            if (data.getOrDefault("error", "false").equals("true")) {
                Object errorNode = new ObjectMapper().valueToTree(data);
                listFutures.add((JsonNode)errorNode);
                continue;
            }
            int taxId = Integer.parseInt(data.get("song_id").toString());
            HajimeAPI4JImpl impl = HajimeAPIBuilder.createDefault((HajimeAPI4J.Token)HajimeAPI4J.Token.MUSIC).addParameter(HajimeAPI4J.Music_Params.ID, new String[]{String.valueOf(taxId)}).build();
            this.logger.info("fetch data : {}", (Object)taxId);
            try {
                try {
                    listFutures.add(impl.get());
                }
                catch (NoSuchURIException | IOException | InterruptedException e) {
                    this.logger.error("Exception while processing json.", e);
                    DelesteRandomSelector.progressTool.setValue(n.incrementAndGet());
                    continue;
                }
            }
            catch (Throwable throwable) {
                DelesteRandomSelector.progressTool.setValue(n.incrementAndGet());
                throw throwable;
            }
            DelesteRandomSelector.progressTool.setValue(n.incrementAndGet());
        }
        DelesteRandomSelector.labelInfoProgressSongName.setText("");
        this.nodes = listFutures;
    }

    private Map<String, Object> fetchList(String songname) {
        Map<String, Object> tmp2;
        HajimeAPI4JImpl api = HajimeAPIBuilder.createDefault((HajimeAPI4J.Token)HajimeAPI4J.Token.LIST).addParameter(HajimeAPI4J.List_Params.TYPE, new String[]{HajimeAPI4J.List_Type.MUSIC.toString()}).addParameter(HajimeAPI4J.List_Params.SEARCH, new String[]{songname}).build();
        ArrayList<Map<String, Object>> parse = Collections.emptyList();
        try {
            parse = (ArrayList<Map<String, Object>>)new ObjectMapper().readValue(api.get().traverse(), new TypeReference<List<Map<String, Object>>>(){});
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (NoSuchURIException | IOException | InterruptedException e) {
            this.logger.error("Exception while processing json map");
        }
        if (parse == null) {
            parse = new ArrayList<Map<String, Object>>(1);
            tmp2 = new HashMap<String, String>();
            tmp2.put("error", "true");
            tmp2.put("name", songname);
            parse.add(tmp2);
        } else if (parse.isEmpty()) {
            parse = new ArrayList(1);
            tmp2 = new HashMap();
            tmp2.put("error", "true");
            tmp2.put("name", songname);
            parse.add(tmp2);
        }
        for (Map<String, Object> tmp2 : parse) {
            String normalizeLocalName;
            String normalizeApiName = Normalizer.normalize(tmp2.get("name").toString(), Normalizer.Form.NFKD);
            if (!normalizeApiName.equalsIgnoreCase(normalizeLocalName = Normalizer.normalize(songname, Normalizer.Form.NFKD))) continue;
            return tmp2;
        }
        HashMap<String, Object> altRes = new HashMap<String, Object>();
        altRes.put("error", "true");
        altRes.put("name", songname);
        return altRes;
    }

    /*
     * Unable to fully structure code
     */
    public List<Map<String, String>> getInformation() {
        block7: {
            resultList = new ArrayList<Map<String, String>>();
            nodeSize = this.nodes.size();
            try {
                TimeUnit.SECONDS.sleep(1L);
                for (JsonNode node : this.nodes) {
                    if (node == null) {
                        tmp = new HashMap<String, String>();
                        errorStr = "Failed to get.";
                        tmp.put("songname", errorStr);
                        tmp.put("link", errorStr);
                        tmp.put("lyric", errorStr);
                        tmp.put("composer", errorStr);
                        tmp.put("arrange", errorStr);
                        tmp.put("member", errorStr);
                        resultList.add(tmp);
                        continue;
                    }
                    if (node.get("error") != null) {
                        tmp = new HashMap<K, V>();
                        errorStr = "Failed to get.";
                        tmp.put("songname", node.get("name").asText());
                        tmp.put("link", errorStr);
                        tmp.put("lyric", errorStr);
                        tmp.put("composer", errorStr);
                        tmp.put("arrange", errorStr);
                        tmp.put("member", errorStr);
                        resultList.add(tmp);
                        continue;
                    }
                    result = new LinkedHashMap<String, String>();
                    result.put("songname", node.get("name").asText());
                    result.put("link", node.get("link").asText());
                    typeRef = new TypeReference<List<Map<String, Object>>>(){};
                    mapper = new ObjectMapper();
                    lyricList = (List)mapper.readValue(node.get("lyrics").traverse(), typeRef);
                    composerList = (List)mapper.readValue(node.get("composer").traverse(), typeRef);
                    arrangeList = (List)mapper.readValue(node.get("arrange").traverse(), typeRef);
                    nameArraySupplyFutures = List.of(CompletableFuture.supplyAsync((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$1(java.util.List ), ()Ljava/lang/String;)((FetchFromAPI)this, (List)lyricList), this.localDispatcher).thenAcceptAsync((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$2(java.util.LinkedHashMap java.lang.String ), (Ljava/lang/String;)V)(result), (Executor)this.localDispatcher), CompletableFuture.supplyAsync((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$3(java.util.List ), ()Ljava/lang/String;)((FetchFromAPI)this, (List)composerList), this.localDispatcher).thenAcceptAsync((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$4(java.util.LinkedHashMap java.lang.String ), (Ljava/lang/String;)V)(result), (Executor)this.localDispatcher), CompletableFuture.supplyAsync((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$5(java.util.List ), ()Ljava/lang/String;)((FetchFromAPI)this, (List)arrangeList), this.localDispatcher).thenAcceptAsync((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$6(java.util.LinkedHashMap java.lang.String ), (Ljava/lang/String;)V)(result), (Executor)this.localDispatcher));
                    memberBuilder = new StringBuilder();
                    for (Member tmpMember : (List)mapper.readValue(node.get("member").traverse(), new TypeReference<List<Member>>(){})) {
                        if (!tmpMember.getProduction().equals("cg")) continue;
                        memberBuilder.append(tmpMember.getName()).append(",");
                    }
                    memberBuilder.deleteCharAt(memberBuilder.length() - 1);
                    result.put("member", memberBuilder.toString());
                    CompletableFuture.allOf(nameArraySupplyFutures.toArray(new CompletableFuture[0])).join();
                    resultList.add(result);
                }
                break block7;
            }
            catch (IOException | InterruptedException e) {
                this.logger.warn("Exception while processing json", (Throwable)e);
                errorStr = "No data";
                i = 0;
                ** while (i < nodeSize)
            }
lbl-1000:
            // 1 sources

            {
                tmp = new HashMap<String, String>();
                tmpNode = this.nodes.get(i);
                tmp.put("songname", tmpNode.get("name").asText());
                tmp.put("link", tmpNode.get("link").asText());
                tmp.put("lyric", errorStr);
                tmp.put("composer", errorStr);
                tmp.put("arrange", errorStr);
                tmp.put("member", errorStr);
                resultList.add(tmp);
                ++i;
                continue;
            }
        }
        resultList.stream().forEach((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$7(java.util.Map ), (Ljava/util/Map;)V)((FetchFromAPI)this));
        return resultList;
    }

    private String getArrayedNames(List<Map<String, Object>> data) {
        if (data == null) {
            return "No Data";
        }
        StringBuilder builder = new StringBuilder();
        for (Map<String, Object> tmp : data) {
            builder.append(tmp.get("name").toString()).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private /* synthetic */ String lambda$1(List list) {
        return this.getArrayedNames(list);
    }

    private static /* synthetic */ void lambda$2(LinkedHashMap linkedHashMap, String str) {
        String string = linkedHashMap.put("lyric", str);
    }

    private /* synthetic */ String lambda$3(List list) {
        return this.getArrayedNames(list);
    }

    private static /* synthetic */ void lambda$4(LinkedHashMap linkedHashMap, String str) {
        String string = linkedHashMap.put("composer", str);
    }

    private /* synthetic */ String lambda$5(List list) {
        return this.getArrayedNames(list);
    }

    private static /* synthetic */ void lambda$6(LinkedHashMap linkedHashMap, String str) {
        String string = linkedHashMap.put("arrange", str);
    }

    private /* synthetic */ void lambda$7(Map map) {
        this.logger.debug("data fetch complete : {}", (Object)map);
    }
}

