/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.ranfa.lib.Easter;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import test.mocks.EasterMock;

public class EasterTest {
    private Easter easter = new Easter();

    @Test
    public void nonNullWebData() {
        Assert.assertNotNull(this.easter.fetchBirthData());
    }

    @Test
    public void nonNullLocalData() {
        Assert.assertNotNull(this.easter.readBirthData());
    }

    @Test
    public void specifiedEasterTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2020, 6, 13);
        Date mutsumi = new Date(calendar.toInstant().toEpochMilli());
        calendar.clear();
        calendar.set(2020, 9, 27);
        Date fumika = new Date(calendar.toInstant().toEpochMilli());
        String mutsumiBirthString = null;
        String fumikaBirthString = null;
        try {
            mutsumiBirthString = EasterMock.getSpecifiedDateBirth(mutsumi);
            fumikaBirthString = EasterMock.getSpecifiedDateBirth(fumika);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)mutsumiBirthString);
        Assert.assertNotNull((Object)fumikaBirthString);
        Assert.assertTrue((boolean)mutsumiBirthString.contains(" \u300c\u304a\u8a95\u751f\u65e5\u3063\u3066\u3001\u306a\u3093\u3060\u304b\u308f\u304f\u308f\u304f\u3057\u307e\u3059\u3088\u306d\u3063\uff01\u300d"));
        Assert.assertTrue((boolean)fumikaBirthString.contains(" \u300c\u7d20\u6575\u306a\u7269\u8a9e\u306e1\u9801\u3092\u3001\u4e00\u7dd2\u306b\u523b\u3093\u3067\u3044\u304d\u307e\u3057\u3087\u3046\u2026\u30d7\u30ed\u30c7\u30e5\u30fc\u30b5\u30fc\u3055\u3093\u300d"));
    }
}

