/*
 * Pred node program copyright (C) 2009 - 2012 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>
#include <complex>

#include "syserr.h"

#include "bin_node.h"
#include "var.h"
#include "context.h"
#include "unify.h"
#include "pred.h"

Node* FreePredNodes = NULL;

// print nodes
void Pred::printsub(FILE* fd) 
{
	if (prcount >= PRCOUNTLIMIT) {
		fprintf(fd, "< ...>");
		return;
	} else {
		if (prcount < PrCount) {
			prcount = PrCount;
		} else {
			prcount++;
		}
	}
	if (node->kind() == LIST) {
		if (node->Car()->kind() == PRED) {
			fprintf(fd, "::<");
			node->Car()->Car()->print(fd);
			fprintf(fd, " ");
			node->Cdr()->print(fd);
			fprintf(fd, ">");
			return;
		} else if (node->Car()->Eq(mka("obj")) ||
		    node->Car()->Eq(mka("unify"))) {
			fprintf(fd, "::");
			node->Cdr()->Car()->printsub(fd); 
			node->Cdr()->Cdr()->printcdrsub(fd);
			return;			    	
		}
	}
	fprintf(fd, "<");
	if (node->kind() == LIST) {
		node->Car()->printsub(fd); 
		node->Cdr()->printcdrsub(fd);
	} else {
		node->printsub(fd);
	}
	fprintf(fd, ">"); 
}

void Pred::printcdrsub(FILE* fd) 
{
	if (this != Nil) {
		if (prcount >= PRCOUNTLIMIT) {
			fprintf(fd, " ...");
			return;
		} else {
			if (prcount < PrCount) {
				prcount = PrCount;
			} else {
				prcount++;
			}
		}

		fprintf(fd, " :<");
		node->Car()->printsub(fd);
		node->Cdr()->printcdrsub(fd);
		fprintf(fd, ">");
	}
}



Node* MkPred(Node* n1)
{
	if (n1->kind() == PRED) {
		return n1;
	}

	if (FreePredNodes == NULL) {
		return new Pred(n1);
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(n1);
		return nd;
	}
		
}

Node* MkPred(Node* n1, Node* n2)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Nil)));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Nil)));
		return nd;
	}
}

Node* MkPred(Node* n1, Node* n2, Node* n3)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Cons(n3, Nil))));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Cons(n3, Nil))));
		return nd;
	}
}

Node* MkPred(Node* n1, Node* n2, Node* n3, Node* n4)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Cons(n3, Cons(n4, Nil)))));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Cons(n3, Cons(n4, Nil)))));
		return nd;
	}
}

Node* MkPred(Node* n1, Node* n2, Node* n3, Node* n4, Node* n5)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Nil))))));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Nil))))));
		return nd;
	}
}

Node* MkPred(Node* n1, Node* n2, Node* n3, Node* n4, Node* n5, Node* n6)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Cons(n6, Nil)))))));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Cons(n6, Nil)))))));
		return nd;
	}
}

Node* MkPred(Node* n1, Node* n2, Node* n3, Node* n4, Node* n5, Node* n6, Node* n7)
{
	if (FreePredNodes == NULL) {
		return new Pred(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Cons(n6, Cons(n7, Nil))))))));
	} else {
		Node* nd = FreePredNodes;
		FreePredNodes = nd->nextnode;
		nd->nextnode = AllNodes->nextnode;
		AllNodes->nextnode = nd;
		((Pred*)nd)->init(Cons(n1, Cons(n2, Cons(n3, 
			Cons(n4, Cons(n5, Cons(n6, Cons(n7, Nil))))))));
		return nd;
	}
}

