class ShopController < ApplicationController
  before_filter :location_check, :except => ['shoplist']

  def shoplist
    @title = 'Ź'
    @shops = Shop.find(:all, :conditions => ['shop_location = ?', @user.user_location] )
  end

  def list
    @title = @shop.shop_name
  end

  def buy
    @title = @shop.shop_name
    @stock = ShopStock.find(:first, :conditions => ['shop_id = ? AND item_id = ?', params[:shopid], params[:id]])
    @have = Stock.find_or_create_by_user_id_and_item_id( @user.id, params[:id] )
    if request.post?
      num = params[:num].to_i
      begin
        flash.now[:info] = @user.buyFromShop( @stock, @have, num )
      rescue => e
        flash.now[:error] = e.message
      end
    end
  end

  def sell
    @title = @shop.shop_name
    @stock = ShopStock.find(:first, :conditions => ['shop_id = ? AND item_id = ?', params[:shopid], params[:id]])
    @have = Stock.find_or_create_by_user_id_and_item_id( session[:user_id], params[:id] )
    if request.post?
      num = params[:num].to_i
      begin
        flash.now[:info] = @user.sellToShop( @stock, @have, num )
      rescue => e
        flash.now[:error] = e.message
      end
    end
  end

  private
  def location_check
    @shop = Shop.find( params[:shopid] )
    redirect_to :action => 'shoplist' unless @shop.shop_location == @user.user_location
  end
end
