module GuildHelper
  def owner_name(order)
    order.owner ? order.owner.user_name : ''
  end

  def print_deadline(order)
    order.deadline? ? order.deadline.strftime('%Y-%m-%d %H:%M') : '-'
  end

  def print_deadline_colored(order)
    ret = '-'
    if order.deadline?
      ret = order.deadline.strftime('%Y-%m-%d %H:%M')
      ret = "<font color=\"red\">#{ret}</font>" if order.deadline < Time.now
    end
    return ret
  end

  def print_standby_order(user, order)
    if_mark( Stock::amount( user.id, order.item_id ) >= order.amount )
  end
end
