class Item < ActiveRecord::Base
  set_primary_key "item_id"

  belongs_to :item_type, :foreign_key => 'item_type_id'
  belongs_to :material, :foreign_key => 'item_material_id'
  has_many :locations

  def mat_hash
    material.material_hash
  end
  
  def num(user_id)
    s = Stock.find_by_user_id_and_item_id( user_id, self.id )
    return (s ? s.stock : 0)
  end

  def description
    self.item_description
  end

  def get_damage(monster)
    ret = 0
    acts = self.item_action
    return ret unless acts
    acts = acts.split(';').collect{|l| l =~ /^damage/i ? l : nil }.compact
    acts.each do |a|
      arr = a.split(':')
      case arr[0]
      when /^damage-monster$/i
        if arr[1] == monster.name
          ret = arr[2]
          break
        end
      when /^damage$/i
        ret = arr[1]
        break
      else
        logger.error "undefined damage-type '#{arr[0]}'"
      end
    end
    return ret
  end

  def self.count_kind
    self.count
  end

  def self.get_random_item_under_price(price)
    kinds = self.count_kind
    loop do
      index = rand( kinds ) + 1
      item = self.find( index )
      if item.item_price <= price
        return item
      end
    end
  end

  def self.find_usable_items(user)
    Stock.find( :all, :joins => 'LEFT JOIN items on items.item_id = stocks.item_id LEFT JOIN item_types on items.item_type_id = item_types.item_type_id',
                :conditions => ['user_id = ? AND stock > 0 AND item_action IS NOT NULL', user.id]
                )
  end
end
