class Monster < ActiveRecord::Base
  def get_items( remain )
    ret = []
    str = self.items
    return unless str
    str.split(';').collect{|l| l.split(',')}.each do |i|
      min, max = *minmax( i[0].to_i, i[1].to_i )
      if min <= remain && remain <= max
        item = Item.find_by_item_name( i[2] )
        unless item
          logger.error "item not found : name '#{i[2]}'"
          next
        end
        num = calc_deq( i[3] )
        ret << {:id => item.id, :num => num, :name => item.item_name}
      end
    end
    return ret
  end

  def battle( user, item )
    defeat = false
    dmg = calc_deq( BattleController::NO_WEAPON_DAMAGE )
    dmg = calc_deq(item.get_damage(self)) if item
    get_items = []
    transaction do
      remain = self.hitpoint - dmg.to_i
      Stock.incr( user.id, item.id, -1 ) if item
      defeat = true if remain <= 0
      get_items = self.get_items( remain )
      get_items.each do |item|
        Stock.incr( user.id, item[:id], item[:num] )
      end
    end
    return [defeat, get_items ]
  end
end

def minmax( v1, v2 )
  return [v1, v2] if v1 < v2
  return [v2, v1]
end
def calc_deq(eq)
  p = DeqParser.new
  begin
    p.parse( eq )
  rescue ParseError
    logger.error "parse error : #{$!}"
    0
  end
end
