class Stock < ActiveRecord::Base
  set_primary_key :stock_id

  MAX_STOCK = 999

  belongs_to :user, :foreign_key => 'user_id'
  belongs_to :item, :foreign_key => 'item_id'

  def self.incr( user_id, item_id, num )
    s = Stock.find(:first, :conditions => ['user_id = ? and item_id = ?',
                                           user_id, item_id ]
                   ) || Stock.new( :user_id => user_id, :item_id => item_id,
                                   :stock => 0 )
    s.incr(num)
  end

  def incr(num)
    temp = stock + num
    temp = MAX_STOCK if temp > MAX_STOCK
    temp = 0 if temp < 0
    self.stock = temp
    save!
    self.stock
  end

  def item_name
    item.item_name
  end
  def item_type
    item.item_type
  end
  def material
    item.material
  end
  def description
    item.item_description
  end
  def num(userid)
    if userid == self.user_id
      self.stock
    else
      s = Stock.find(:first, :conditions => ['item_id = ? and user_id = ?',
                                             self.item_id, userid ] )
      s ? s.stock : 0
    end
  end

  def self.amount( user_id, item_id )
    s = self.find(:first, :conditions => ['user_id = ? AND item_id = ?',
                                          user_id, item_id] )
    return s ? s.stock : 0
  end

  def self.count_kind( user_id )
    s = self.find(:all, :conditions => ['user_id = ?', user_id] )
    return s ? s.size : 0
  end
end
