# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 17) do

  create_table "books", :force => true do |t|
    t.column "book_name", :string
    t.column "location_id", :integer
    t.column "contents", :text
    t.column "condition", :string
  end

  create_table "crontabs", :force => true do |t|
    t.column "time_at", :datetime, :null => false
    t.column "command", :string, :null => false
    t.column "interval", :integer
  end

  create_table "experiences", :force => true do |t|
    t.column "user_id", :integer
    t.column "item_id", :integer
  end

  create_table "guild_consignments", :force => true do |t|
    t.column "user_id", :integer
    t.column "item_id", :integer
    t.column "stock", :integer
    t.column "price", :integer
  end

  create_table "guild_orders", :force => true do |t|
    t.column "location_id", :integer
    t.column "owner_id", :integer
    t.column "item_id", :integer
    t.column "amount", :integer
    t.column "price", :integer
    t.column "worker_id", :integer
    t.column "done", :boolean, :default => false
    t.column "deadline", :datetime
  end

  create_table "item_types", :primary_key => "item_type_id", :force => true do |t|
    t.column "item_type_name", :string
  end

  create_table "items", :primary_key => "item_id", :force => true do |t|
    t.column "item_name", :string
    t.column "item_material_id", :integer
    t.column "item_type_id", :integer
    t.column "item_price", :integer
    t.column "item_description", :string
    t.column "item_action", :text
  end

  create_table "letters", :force => true do |t|
    t.column "dest_id", :integer
    t.column "src_id", :integer
    t.column "title", :string
    t.column "contents", :text
    t.column "send_at", :datetime, :null => false
    t.column "is_read", :boolean
  end

  add_index "letters", ["dest_id"], :name => "letters_dest_id_index"

  create_table "location_picks", :force => true do |t|
    t.column "location_id", :integer
    t.column "item_id", :integer
    t.column "stock", :integer
    t.column "permill", :integer
    t.column "challenge", :integer
    t.column "supply", :integer
    t.column "supply_permill", :integer
    t.column "max_per_user", :integer
  end

  create_table "locations", :force => true do |t|
    t.column "location_name", :string
    t.column "has_guild", :boolean, :default => false
    t.column "has_library", :boolean, :default => false
    t.column "parent_id", :integer
  end

  create_table "materials", :primary_key => "material_id", :force => true do |t|
    t.column "material_name", :string
    t.column "material_hash", :string
  end

  create_table "monsters", :force => true do |t|
    t.column "name", :string
    t.column "hitpoint", :integer
    t.column "items", :text
  end

  create_table "pick_restrictions", :force => true do |t|
    t.column "user_id", :integer
    t.column "location_id", :integer
    t.column "count", :integer, :default => 0
    t.column "start_date", :datetime, :default => Wed Oct 01 11:56:27 +0900 2008
  end

  create_table "recipes", :primary_key => "recipe_id", :force => true do |t|
    t.column "recipe_material_hash", :string
    t.column "recipe_result_source", :string
    t.column "recipe_result_id", :integer
  end

  create_table "shop_stocks", :force => true do |t|
    t.column "shop_id", :integer, :null => false
    t.column "item_id", :integer, :null => false
    t.column "stock", :integer, :default => 0
    t.column "price", :integer
    t.column "supply", :integer
    t.column "maximum", :integer
    t.column "rest", :integer
  end

  create_table "shops", :force => true do |t|
    t.column "shop_name", :string
    t.column "shop_location", :integer
  end

  create_table "stocks", :primary_key => "stock_id", :force => true do |t|
    t.column "user_id", :integer
    t.column "item_id", :integer
    t.column "stock", :integer, :default => 0
  end

  add_index "stocks", ["user_id"], :name => "index_stocks_user_id"

  create_table "users", :primary_key => "user_id", :force => true do |t|
    t.column "user_name", :string
    t.column "user_salt", :string
    t.column "user_pass_hash", :string
    t.column "user_money", :integer
    t.column "user_start", :datetime
    t.column "user_location", :integer
    t.column "success_order", :integer, :default => 0
    t.column "cancel_order", :integer, :default => 0
  end

end
