class Admin::LetterController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @letter_pages, @letters = paginate :letters, :per_page => 10
  end

  def show
    @letter = Letter.find(params[:id])
  end

  def new
    @letter = Letter.new
  end

  def create
    params[:letter][:src_id] = Letter.user_from_name( params[:src_name] )
    params[:letter][:dest_id] = Letter.user_from_name( params[:dest_name] )
    @letter = Letter.new(params[:letter])
    if @letter.save
      flash[:notice] = 'Letter was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @letter = Letter.find(params[:id])
  end

  def update
    params[:letter][:src_id] = Letter.user_from_name( params[:src_name] )
    params[:letter][:dest_id] = Letter.user_from_name( params[:dest_name] )
    @letter = Letter.find(params[:id])
    if @letter.update_attributes(params[:letter])
      flash[:notice] = 'Letter was successfully updated.'
      redirect_to :action => 'show', :id => @letter
    else
      render :action => 'edit'
    end
  end

  def destroy
    Letter.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
