class Admin::LocationMonsterController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @location_monster_pages, @location_monsters = paginate :location_monsters, :per_page => 10
  end

  def show
    @location_monster = LocationMonster.find(params[:id])
  end

  def new
    @location_monster = LocationMonster.new
  end

  def create
    params[:location_monster][:location_id] = LocationMonster.location_from_name( params[:location_str] )
    params[:location_monster][:monster_id] = LocationMonster.monster_from_name( params[:monster_str] )
    @location_monster = LocationMonster.new(params[:location_monster])
    if @location_monster.save
      flash[:notice] = 'LocationMonster was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @location_monster = LocationMonster.find(params[:id])
  end

  def update
    params[:location_monster][:location_id] = LocationMonster.location_from_name( params[:location_str] )
    params[:location_monster][:monster_id] = LocationMonster.monster_from_name( params[:monster_str] )
    @location_monster = LocationMonster.find(params[:id])
    if @location_monster.update_attributes(params[:location_monster])
      flash[:notice] = 'LocationMonster was successfully updated.'
      redirect_to :action => 'show', :id => @location_monster
    else
      render :action => 'edit'
    end
  end

  def destroy
    LocationMonster.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
