class Admin::MonsterController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @monster_pages, @monsters = paginate :monsters, :per_page => 10
  end

  def show
    @monster = Monster.find(params[:id])
  end

  def new
    @monster = Monster.new
  end

  def create
    @monster = Monster.new(params[:monster])
    if @monster.save
      flash[:notice] = 'Monster was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @monster = Monster.find(params[:id])
  end

  def update
    @monster = Monster.find(params[:id])
    if @monster.update_attributes(params[:monster])
      flash[:notice] = 'Monster was successfully updated.'
      redirect_to :action => 'show', :id => @monster
    else
      render :action => 'edit'
    end
  end

  def destroy
    Monster.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
