class Admin::ShopStockController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @shop_stock_pages, @shop_stocks = paginate :shop_stocks, :per_page => 10
  end

  def show
    @shop_stock = ShopStock.find(params[:id])
  end

  def new
    @shop_stock = ShopStock.new
  end

  def create
    params[:shop_stock][:item_id] = ShopStock.item_from_name( params[:item_str] )
    params[:shop_stock][:location_id] = ShopStock.location_from_name( params[:location_str] )
    @shop_stock = ShopStock.new(params[:shop_stock])
    if @shop_stock.save
      flash[:notice] = 'ShopStock was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @shop_stock = ShopStock.find(params[:id])
  end

  def update
    params[:shop_stock][:item_id] = ShopStock.item_from_name( params[:item_str] )
    params[:shop_stock][:location_id] = ShopStock.location_from_name( params[:location_str] )
    @shop_stock = ShopStock.find(params[:id])
    if @shop_stock.update_attributes(params[:shop_stock])
      flash[:notice] = 'ShopStock was successfully updated.'
      redirect_to :action => 'show', :id => @shop_stock
    else
      render :action => 'edit'
    end
  end

  def destroy
    ShopStock.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
