class LetterController < ApplicationController
  layout 'layouts/application'

  def list
    @title = ''
    @letter_pages, @letters = paginate( :letter, :per_page => 20,
                                        :conditions => ['dest_id = ? OR dest_id IS NULL', @user.id],
                                        :order_by => 'id DESC'
                                        )
  end

  def read
    if params[:id]
      letter = Letter.find( params[:id].to_i )
      if letter.dest_id == nil or letter.dest_id == @user.id
        @letter = letter
        @title = @letter.title
        if letter.dest_id != nil
          @letter.is_read = true
          @letter.save
        end
      else
        flash.now[:error] = "ֹ椬Ǥ"
        list
        render 'letter/list'
      end
    else
      list
      render 'letter/list'
    end
  end
  def erase
    if params[:id]
      letter = Letter.find( params[:id].to_i )
      if letter.dest_id == @user.id
        if letter.is_read?
          letter.destroy
          flash.now[:info] = "ޤ"
        else
          flash.now[:info] = "̤ɤμϺǤޤ"
        end
      elsif letter.dest_id == nil
        flash.now[:error] = "ƥफμϺǤޤ"
      else
        flash.now[:error] = "ֹ椬Ǥ"
      end
    end
    list
    render 'letter/list'
  end
end
