class CreateLocationPicks < ImportMigration
  def self.up
    create_table :location_picks do |t|
      # t.column :name, :string
      t.column :location_id, :integer
      t.column :item_id, :integer
      t.column :stock, :integer
      t.column :permill, :integer
      t.column :challenge, :integer
      t.column :supply, :integer
      t.column :supply_permill, :integer
      t.column :max_per_user, :integer
    end

    do_file_import( "input_location_pick.csv" ) do |arr|
      loc = Location.find_by_location_name(arr[0])
      unless loc
        log.debug("unknown location : #{arr[0]}")
        next
      end
      LocationPick.create(
                          :location_id => loc.id,
                          :item_id => Item.find_by_item_name(arr[1]).id,
                          :stock => (arr[2].to_i / 100.0).ceil,
                          :max_per_user => arr[2].to_i,
                          :permill => arr[3].to_i,
                          :challenge => arr[4].to_i,
                          :supply_permill => arr[5].to_i,
                          :supply => arr[6].to_i
                          )
    end
  end

  def self.down
    drop_table :location_picks
  end
end
