class CreateShops < ImportMigration
  def self.up
    create_table :shops do |t|
      # t.column :name, :string
      t.column :shop_name, :string
      t.column :shop_location, :integer
    end
    
    do_file_import( "input_shop.csv" ) do |arr|
      loc = Location.find_by_location_name( arr[1] ).id
      Shop.create( :shop_name => arr[0], :shop_location => loc )
    end
  end

  def self.down
    drop_table :shops
  end
end
