class Book < ActiveRecord::Base
  belongs_to :location

  def can_read?(user_id)
    return true unless condition && condition.size > 0
    exp = Experience.find( :all, :conditions => ["user_id = ? and item_id in (#{condition})", user_id ] )
    cond = condition.split(',')
    return exp.size == cond.size
  end

  def condition_str
    return '' unless condition && condition.size > 0
    condition.split(',').collect do |c|
      i = nil
      begin
        i = Item.find( c.to_i )
      rescue
        # nothing to do
      end
      i && i.item_name
    end.compact.join(',')
  end

  def self.condition_from_str(str)
    return nil unless str && str.size > 0
    str.split(',').collect do |s|
      i = Item.find_by_item_name( s )
      i && i.id
    end.compact.join(',')
  end
end
