class Item < ActiveRecord::Base
  set_primary_key "item_id"

  validates_presence_of :item_name, :item_price, :item_type_id, :item_material_id

  belongs_to :item_type, :foreign_key => 'item_type_id'
  belongs_to :material, :foreign_key => 'item_material_id'
  has_one :experience, :foreign_key => 'item_id'

  def mat_hash
    material.material_hash
  end

  def num(user_id)
    return 100
  end

  def description
    self.item_description
  end

  def type_name
    self.item_type.item_type_name
  end

  def material_name
    self.material.material_name
  end

  def get_damage(monster)
    ret = 0
    return ret
  end

  def rate_price
    # TODO : re-implement
    item_price
  end

  def self.count_kind
    self.count
  end

  def self.get_random_item_under_price(price)
    kinds = self.count_kind
    loop do
      index = rand( kinds ) + 1
      item = self.find( index )
      if item.item_price <= price
        return item
      end
    end
  end

  def self.find_usable_items(user)
    []
  end
end
