CREATE TABLE items (
  item_id integer PRIMARY KEY,
  item_name varchar NOT NULL,
  item_hash varchar NOT NULL,
  item_material_id integer NOT NULL,
  item_type_id integer NOT NULL,
  item_description varchar
);

CREATE TABLE item_types (
  item_type_id integer PRIMARY KEY,
  item_type_name varchar NOT NULL
);

CREATE TABLE materials (
  material_id integer PRIMARY KEY,
  material_name varchar NOT NULL,
  material_hash varchar NOT NULL
);

CREATE TABLE recipes (
  recipe_id integer PRIMARY KEY,
  recipe_material_hash varchar NOT NULL,
  recipe_result_hash varchar NOT NULL,
  recipe_result_id integer NOT NULL
);

CREATE TABLE users (
  user_id serial PRIMARY KEY,
  user_name varchar NOT NULL UNIQUE,
  user_salt varchar,
  user_pass_hash varchar,
  user_start timestamp NOT NULL default 'now()'::text::timestamp
);
