require 'digest/md5'
require 'app/controllers/application'
require 'import_migration'

class ImportMaster < ImportMigration
  def self.up
    create_table :item_types, :primary_key => 'item_type_id' do |t|
      t.column :item_type_name, :string
    end
    do_file_import( "input_type.csv" ) do |arr|
      ItemType.create( :item_type_name => arr[0] )
    end

    create_table :materials, :primary_key => 'material_id' do |t|
      t.column :material_name, :string
      t.column :material_hash, :string
    end
    do_file_import( "input_material.csv" ) do |arr|
      Material.create( :material_name => arr[0], :material_hash => Digest::MD5.hexdigest(arr[0]) )
    end

    create_table :items, :primary_key => 'item_id' do |t|
      t.column :item_name, :string
      t.column :item_material_id, :integer
      t.column :item_type_id, :integer
      t.column :item_price, :integer
      t.column :item_description, :string
    end
    STDERR.print "import input_item.csv ..."
    do_file_import( "input_item.csv" ) do |arr|
      type_id = ItemType.find_by_item_type_name( arr[0] ).id
      material_id = Material.find_by_material_name( arr[1] ).id
      Item.create( :item_name => arr[2],
                   :item_type_id => type_id,
                   :item_material_id => material_id,
                   :item_price => arr[3],
                   :item_description => arr[4]
                   )
    end
    STDERR.puts " done."

    create_table :recipes, :primary_key => 'recipe_id' do |t|
      t.column :recipe_material_hash, :string
      t.column :recipe_result_source, :string
      t.column :recipe_result_id, :integer
    end
    do_file_import( "input_recipe.csv" ) do |arr|
      item_name = arr.shift
      result = Item.find_by_item_name( item_name )
      unless result
        log.debug("unknown item name :#{item_name}")
        next
      end
      material_hash = 0
      src = []
      arr.each do |mat|
        m = Item.find_by_item_name( mat )
        material_hash += m.material.material_hash.hex
        src << m.item_name
      end
      Recipe.create( :recipe_material_hash => '%X' % (material_hash & ApplicationController::HASH_MASK),
                     :recipe_result_source => src.sort.join(','),
                     :recipe_result_id => result.id
                     )
    end
  end

  def self.down
    drop_table :recipes
    drop_table :items
    drop_table :item_types
    drop_table :materials
  end
end
