/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.win32;

import com.aibonware.viewnaver.browser.win32.Win32BrowserImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Formatter;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;

public class RichEditDecorator
extends JPanel {
    private final Win32BrowserImpl browser;
    private String delayHtml = null;

    public RichEditDecorator(final Win32BrowserImpl browser, final Container parent) {
        super(new BorderLayout());
        this.browser = browser;
        browser.beginDocWriting();
        browser.writeDocHtml("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body></body></html>");
        browser.endDocWriting();
        JPanel browserPanel = new JPanel(new BorderLayout());
        browserPanel.setBorder(new BevelBorder(1));
        RichEditDecorator browserAndToolPanel = this;
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton toggleBoldButton = new JButton("B");
        JButton toggleItalicButton = new JButton("I");
        JButton toggleUnderlineButton = new JButton("U");
        JButton insertHRButton = new JButton("HR");
        final JComboBox<String> fontNameCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        final JComboBox<String> fontSizeCombo = new JComboBox<String>(new String[]{"-2", "-1", "+0", "+1", "+2", "+3", "+4", "+5"});
        JButton colorButton = new JButton("Color");
        fontNameCombo.setEditable(true);
        fontSizeCombo.setEditable(true);
        fontNameCombo.setSelectedItem("");
        fontSizeCombo.setSelectedItem("");
        toggleBoldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.toggleBold();
            }
        });
        toggleItalicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.toggleItalic();
            }
        });
        toggleUnderlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.toggleUnderLine();
            }
        });
        insertHRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.insertHR();
            }
        });
        fontNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.setFontName((String)fontNameCombo.getSelectedItem());
            }
        });
        fontSizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.setFontSize((String)fontSizeCombo.getSelectedItem());
            }
        });
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(parent, "Color Chooser", Color.black);
                if (color == null) {
                    return;
                }
                String colorText = new Formatter().format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()).toString();
                browser.setColor(colorText);
            }
        });
        toolbar.add(toggleBoldButton);
        toolbar.add(toggleItalicButton);
        toolbar.add(toggleUnderlineButton);
        toolbar.add(insertHRButton);
        toolbar.addSeparator();
        toolbar.add(fontNameCombo);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Size:"));
        toolbar.add(fontSizeCombo);
        toolbar.addSeparator();
        toolbar.add(colorButton);
        browserPanel.add(browser.getComponent(), "Center");
        browserAndToolPanel.add((Component)toolbar, "North");
        browserAndToolPanel.add((Component)browserPanel, "Center");
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getHtml() {
        return this.browser.getBodyHtml();
    }

    public void setHtml(String html) {
        this.browser.setBodyHtml(html);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.browser == null) {
            return;
        }
        this.browser.setEditable(true);
        if (this.delayHtml != null) {
            this.browser.setBodyHtml(this.delayHtml);
        }
    }

    public void setInitialHtml(String html) {
        this.delayHtml = html;
    }
}

