/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.command;

import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.model.SearchType;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.BoardTitleProvider;
import com.aibonware.viewnaver.command.PosterSelection;
import com.aibonware.viewnaver.command.PosterSelectionListener;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.board.FoundThreadsContent;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.window.IDJitenWindow;
import com.aibonware.viewnaver.window.WriteMessageWindow;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PosterMenuItems {
    public final JMenuItem sendMessageMenu;
    public final JMenuItem idJitenMenu;
    public final JMenuItem favMenu;
    public final JMenuItem filterMenu;
    public final JMenuItem hiddenFilterMenu;
    public final JMenuItem searchMenu;
    private final AbstractAction sendMessageAction;
    private final AbstractAction idJitenAction;
    private SessionListener sessionListener;

    private static Window searchParentWindow(Container container) {
        while (!((container = container.getParent()) instanceof Window)) {
        }
        return (Window)container;
    }

    public PosterMenuItems(final TabContentView contentView, final PosterSelection posterSelection, final BoardTitleProvider boardTitleProvider) {
        this.sendMessageAction = new AbstractAction("\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                WriteMessageWindow messageWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, poster.name, poster.country, "");
                messageWindow.setVisible(true);
            }
        };
        this.idJitenAction = new AbstractAction("ID\u8f9e\u5178..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                IDJitenList idJiten = ViewNaver.instance.idJiten;
                if (idJiten == null) {
                    return;
                }
                String explain = idJiten.getExplain(poster);
                if (explain != null) {
                    IDJitenWindow idwindow = IDJitenWindow.createIDJitenWindow(PosterMenuItems.searchParentWindow(contentView), poster.name, explain);
                    idwindow.setLocation(100, 100);
                    idwindow.setVisible(true);
                }
            }
        };
        this.sendMessageMenu = new JMenuItem(this.sendMessageAction);
        this.idJitenMenu = new JMenuItem(this.idJitenAction);
        this.favMenu = new JMenuItem(new AbstractAction("\u304a\u6c17\u306b\u5165\u308aID\u306b\u8ffd\u52a0"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFavoritePersonConfig().persons.add(poster);
                contentView.refreshContent();
            }
        });
        this.filterMenu = new JMenuItem(new AbstractAction("\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFilterConfig().filters.put(new Poster(poster.name, poster.country), FilterType.Visible);
                contentView.refreshContent();
            }
        });
        this.hiddenFilterMenu = new JMenuItem(new AbstractAction("\u900f\u660e\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFilterConfig().filters.put(new Poster(poster.name, poster.country), FilterType.Hidden);
                contentView.refreshContent();
            }
        });
        this.searchMenu = new JMenuItem(new AbstractAction("\uff7d\uff9a\u691c\u7d22"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                BoardTitle boardTitle = boardTitleProvider.getBoardTitle();
                TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
                TabContentCategory category = FoundThreadsContent.getConstantCategory(boardTitle, SearchType.SearchByPoster, poster.name);
                containerView.update(category);
            }
        });
        this.idJitenMenu.setEnabled(false);
        posterSelection.addPosterSelectionListener(new PosterSelectionListener(){

            @Override
            public void selected(Poster poster) {
                IDJitenList idJiten;
                if (poster == null) {
                    PosterMenuItems.this.idJitenMenu.setEnabled(false);
                }
                if ((idJiten = ViewNaver.instance.idJiten) == null || idJiten.getExplain(poster) == null) {
                    PosterMenuItems.this.idJitenMenu.setEnabled(false);
                } else {
                    PosterMenuItems.this.idJitenMenu.setEnabled(true);
                }
            }
        });
        this.beginListen();
    }

    public void addAllto(JPopupMenu popup) {
        popup.add(this.sendMessageMenu);
        popup.add(this.idJitenMenu);
        popup.add(this.favMenu);
        popup.add(this.filterMenu);
        popup.add(this.hiddenFilterMenu);
        popup.add(this.searchMenu);
    }

    private void beginListen() {
        this.sessionListener = new SessionListener(){

            @Override
            public void loginChanged(String userName, boolean nowLogin) {
                PosterMenuItems.this.sendMessageAction.setEnabled(nowLogin);
            }
        };
        ViewNaver.instance.multiSession.addSessionListener(this.sessionListener);
    }

    public void endListen() {
        ViewNaver.instance.multiSession.removeSessionListener(this.sessionListener);
    }
}

