/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.parser;

import com.aibonware.nvrlib.BaseInstantiator;
import com.aibonware.nvrlib.model.BaseArticle;
import com.aibonware.nvrlib.model.BaseArticleList;
import com.aibonware.nvrlib.model.BaseBoard;
import com.aibonware.nvrlib.model.BaseCompositeThread;
import com.aibonware.nvrlib.model.BaseFoundThreads;
import com.aibonware.nvrlib.model.BaseThread;
import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.BaseBoardParser;
import com.aibonware.nvrlib.parser.ParsingContext;
import com.aibonware.nvrlib.parser.ParsingException;
import java.io.BufferedReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class BaseThreadParser<TBoard extends BaseBoard<TThread>, TCompositeThread extends BaseCompositeThread<TArticle, TArticleList, TThread>, TArticle extends BaseArticle<TArticle>, TArticleList extends BaseArticleList<TArticle>, TFoundThreads extends BaseFoundThreads<TThread>, TThread extends BaseThread, TBoardParser extends BaseBoardParser<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>, TThreadParser extends BaseThreadParser<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>, TInstantiator extends BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>> {
    public TArticleList resultArticleList = null;
    public String resultRawContents = null;
    public TThread resultThread = null;
    private TThread templateThread = null;
    private BufferedReader reader;
    private static SimpleDateFormat articleDateFormat = new SimpleDateFormat("MM-dd HH:mm");
    private static SimpleDateFormat threadDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator> modelProvider;

    public BaseThreadParser(BufferedReader reader, TThread templateThread, BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator> modelProvider) {
        this.reader = reader;
        this.templateThread = templateThread;
        this.modelProvider = modelProvider;
    }

    public void parse() throws NetException, ParsingException {
        ParsingContext ct = new ParsingContext(this.reader);
        this.parseThreadHeaderAndContents(ct, this.templateThread);
        this.resultArticleList = this.modelProvider.createArticleList();
        this.parseAricleList(((BaseThread)this.resultThread).createDate, (BaseArticleList<TArticle>)this.resultArticleList, ct);
    }

    private void parseThreadHeaderAndContents(ParsingContext ct, TThread templateThread) throws ParsingException {
        try {
            int nid = Integer.parseInt(ct.cut("name=nid value='", "'"));
            String title = ct.cut("typo_ms03'>", "</span>");
            ct.seek("typo_ms05");
            String viewNumText = ct.cut("color:#929292;'>", "</span>");
            int viewNum = Integer.parseInt(viewNumText);
            ct.seek("typo_ms04");
            String dispId = ct.cut("style='padding:0 0 0 6px;'>", "</span>");
            String countryText = ct.cut(null, "<a href=\"");
            int japan = countryText.indexOf("alt='JAPAN'");
            int korea = countryText.indexOf("alt='KOREA'");
            japan = japan >= 0 ? japan : Integer.MAX_VALUE;
            korea = korea >= 0 ? korea : Integer.MAX_VALUE;
            Country country = japan < korea ? Country.JAPAN : Country.KOREA;
            String poster = ct.cut(null, "class='num03'").trim();
            if (poster.contains("javascript:ui")) {
                int start = poster.indexOf("('") + "('".length();
                int end = poster.indexOf("',");
                poster = poster.substring(start, end);
            } else if (poster.contains("\u904b\u55b6\u8005")) {
                poster = "enjoymaster";
            }
            String dateText = ct.cut("class='num01'>", "</span>").trim();
            Date createDate = threadDateFormat.parse(dateText);
            String enqueteText = ct.cut(null, "num06");
            StringBuffer enqueteHtml = new StringBuffer();
            if (enqueteText.indexOf("<span id='poll'>") >= 0) {
                ParsingContext enqct = new ParsingContext(enqueteText);
                enqct.seek("<tr class='PollTitle'>");
                enqct.seek("<table");
                enqueteHtml.append("#\u30a2\u30f3\u30b1\u30fc\u30c8<table>");
                while (enqct.seek("class=c>", "</table>")) {
                    String name = enqct.cut(null, "</td>");
                    String value = enqct.cut("class=c>", "</td>");
                    enqueteHtml.append("<tr><td>");
                    enqueteHtml.append(name);
                    enqueteHtml.append("</td><td>");
                    enqueteHtml.append(value);
                    enqueteHtml.append("</td></tr>");
                    enqct.seek("<tr><td height=10 colspan=3></td></tr>");
                }
                enqueteHtml.append("</table>");
            }
            ct.seek("<div");
            String contentsText = ct.cut(">", "<script for=window event=onload>");
            int end = contentsText.lastIndexOf("</div>");
            end = contentsText.lastIndexOf("</div>", end - 1);
            this.resultRawContents = enqueteHtml + contentsText.substring(0, end);
            this.resultThread = templateThread != null ? this.modelProvider.createThread(((BaseThread)templateThread).depth, dispId, ((BaseThread)templateThread).isAdminThread, ((BaseThread)templateThread).nid, ((BaseThread)templateThread).country, title, ((BaseThread)templateThread).articleNum, poster, createDate, createDate, viewNum, ((BaseThread)templateThread).mail, new Date(), ((BaseThread)templateThread).isHot, null) : this.modelProvider.createThread(0, dispId, false, nid, country, title, -1, poster, createDate, createDate, viewNum, null, new Date(), false, null);
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }

    public void parseAricleList(Date startDate, BaseArticleList<TArticle> articleList, ParsingContext ct) throws ParsingException {
        try {
            while (true) {
                String snoPrefix;
                ct.seek("<td height='11'></td>");
                if (!ct.seek("<td align='left' nowrap>", "btn_bbs_write")) break;
                String replyText = ct.cut(null, "<span style='padding:0 5px 0 8px;'>");
                boolean isReply = replyText.indexOf(8594) >= 0;
                String countryText = ct.cut("http://static.naver.com/enjoykorea/uin/", ">");
                Country country = countryText.contains("ico_kor") ? Country.KOREA : (countryText.contains("ico_jpn") ? Country.JAPAN : Country.UNKNOWN);
                String author = ct.cut(null, "<span class='num01'>");
                if (author.contains("\u904b\u55b6\u8005")) {
                    author = "enjoymaster";
                } else {
                    int start = author.indexOf("class='num03 1px_up'>") + "class='num03 1px_up'>".length();
                    int end = author.indexOf("</a>", start);
                    author = author.substring(start, end);
                }
                String dateText = ct.cut(null, "</span>");
                Date postDate = articleDateFormat.parse(dateText);
                String contents = ct.cut("'num09'>", " </td>");
                contents = contents.replace("\r\n", "<br>");
                int delPos = contents.indexOf(" <a href='javascript:delete_ment(");
                if (delPos != -1) {
                    contents = contents.substring(0, delPos);
                }
                if (isReply && contents.startsWith("&nbsp;&nbsp;&nbsp;&nbsp;")) {
                    contents = contents.substring("&nbsp;&nbsp;&nbsp;&nbsp;".length());
                }
                int articleId = Integer.parseInt(ct.cut("<div id='repl_", "'"));
                int sno = -1;
                String snoText = ct.cut("name='re_reply", "</table>");
                int start = snoText.indexOf(snoPrefix = "return add_reply(\"");
                if (start != -1) {
                    int end = snoText.indexOf(34, start + snoPrefix.length());
                    sno = Integer.parseInt(snoText.substring(start + snoPrefix.length(), end));
                }
                articleList.addArticle(this.modelProvider.createArticle(author, country, contents, articleId, postDate, isReply, sno));
            }
            GregorianCalendar carendar = new GregorianCalendar();
            carendar.setTime(startDate);
            carendar.add(12, -1);
            startDate = carendar.getTime();
            int year = carendar.get(1);
            int i = 0;
            while (i < articleList.getArticleCount()) {
                TArticle art = articleList.getArticle(i);
                carendar.setTime(((BaseArticle)art).postDate);
                carendar.add(1, year - 1970);
                Date newPostDate = carendar.getTime();
                articleList.replaceArticle(i, ((BaseArticle)art).replacePostDate(newPostDate));
                ++i;
            }
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }

    public TThread getResultThread() {
        return this.resultThread;
    }

    public String getResultRawContents() {
        return this.resultRawContents;
    }

    public TArticleList getResultArticleList() {
        return this.resultArticleList;
    }
}

