#define CACHE_TEXT 0


#define SD_CANTDELETE (1)

#define DLG_OK	 (1)
#define DLG_YES	 (1 << 1)
#define DLG_NO	 (1 << 2)
#define DLG_OVERWRITE	 (1 << 3)
#define DLG_RETRY	 (1 << 4)
#define DLG_SKIP	 (1 << 5)
#define DLG_RENAME	 (1 << 6)
#define DLG_CANCEL	 (1 << 7)

#define DLGF_MULTIPARAM		(1 << 7)

#ifndef DFTASK
typedef struct dftask_t DfTask;
#define DFTASK
#endif

typedef struct dfdialog_t DfDialog;
typedef struct dfmbox_t DfMessageBox;
typedef struct dfinputdlg_t DfInputDialog;
typedef struct dfchmoddialog_t DfChmodDialog;

struct dialog_vtable
{
  void (*destroy)(DfDialog *);
  void (*confirm)(Widget, DfDialog *);
};

enum dlg_type
{
  DLG_MESSAGE,
  DLG_INPUT,
  DLG_CHMOD
};

struct dfdialog_t
{
  enum dlg_type type;
  int flag;
  struct dialog_vtable *v;
  DfTask *task;
  DfBuf *owner;
  Widget w;
  XRectangle rc;/* require position */
  Widget shell;/* dialog's shell widget */
  Widget dialog;
};

struct dfmbox_t
{
  struct dfdialog_t b;
  int buttons;
};

struct dfinputdlg_t
{
  struct dfdialog_t b;
  Widget text;/* text widget versatile use */
  DfStr input;/* must be release */
  int (*keyproc)(DfDialog *, Widget,  KeySym, char, Boolean *);
  DfStr cand;
  char *cand_ptr;
  int cand_idx;
  int cand_insert;
};

struct dfchmoddialog_t
{
  struct dfdialog_t b;
  int mode;
  int subdir;
  int colum;
  int cx;
  int cy;
  Widget label;
  Widget chk;
  Widget buttons[3][4];
};

DfMessageBox *MakeMessageBox(DfTask *t);
DfInputDialog *MakeInputDialog(DfTask *t, const char *str, int (*keyproc)(DfDialog *, Widget,  KeySym, char, Boolean *));
DfChmodDialog *MakeChmodDialog(DfTask *t);

int inputKeyProc(DfDialog *d, Widget w, KeySym k, char ch, Boolean *cont);
int copyKeyProc(DfDialog *d, Widget w, KeySym k, char ch, Boolean *cont);
int isearchKeyProc(DfDialog *d, Widget w, KeySym k, char ch, Boolean *cont);

void CandidateList(DfInputDialog *d, Widget w);

void CalcDialogRect(DfFileList *l, XRectangle *rc);
int ShowInputDialog(DfInputDialog *d, int msg);
int ShowDialog(DfBuf *owner, DfMessageBox *d, const char *label, int fButtons);
int ShowChmodDialog(DfBuf *owner, DfChmodDialog *d);

