#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h> 

#include <sys/types.h> 
#include <sys/stat.h> 
#include <unistd.h>
#include <time.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "misc.h"
#include "xutil.h"
#include "dfxfunc.h"
#include "dfval.h"

void AddRect(XRectangle *rc, int x, int y, int width, int height)
{
  int ox;
  int oy;
  int cx;
  int cy;

  ox = rc->x + rc->width;
  oy = rc->y + rc->height;
  cx = x + width;
  cy = y + height;

  if(x < rc->x){
    rc->x = x;
  }

  if(y < rc->y){
    rc->y = y;
  }
  
  if(ox < cx){
    ox = cx;
  }
  rc->width = ox - rc->x;
  if(oy < cy){
    oy = cy;
  }
  rc->height = oy - rc->y;

}

unsigned long xAllocColor(Display *d, const char *color)
{
  Colormap c_map;
  XColor c1, c2;

  c_map = DefaultColormap(d, DefaultScreen(d));
  XAllocNamedColor(d, c_map, color, &c1, &c2);

  return c1.pixel;
}

void InvalidateWindow(Widget w)
{
  XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
}

void InvalidateRect(Widget w, XRectangle *rc)
{

  XClearArea(XtDisplay(w), XtWindow(w), rc->x, rc->y, rc->width, rc->height, True);
}

#ifdef SetClipRect

struct clip_info{
  const char *file;
  int line;
  XRectangle rc;
};
struct clip_info vClip;

void SetClipRectLogging(Display *d, GC gc, XRectangle *rc, const char *file, int line)
{
  vClip.file = file;
  vClip.line = line;
  vClip.rc = *rc;
  XSetClipRectangles(d, gc, 0, 0, rc, 1, Unsorted);
}

#else

void SetClipRect(Display *d, GC gc, XRectangle *rc)
{
  XSetClipRectangles(d, gc, 0, 0, rc, 1, Unsorted);
}
#endif

void ClearClip(Display *d, GC gc)
{
#ifdef SetClipRect

  vClip.file = NULL;
  vClip.line = 0;
  vClip.rc.width = 0;
  vClip.rc.height = 0;
#endif
  XSetClipMask(d, gc, None);
}

unsigned long int rdtsc(void)
{
  unsigned long int tsc;
  __asm(
    "rdtsc"
    : "=r" (tsc)
    );
  return tsc;
}

int IsAllNum(const char *str)
{
  while(*str){
    if(!isdigit(*str)){
      return 0;
    }
    str++;
  }
  return 1;
}

static int h2d(int hex)
{
  hex *= 10;
  hex /= 1024;
  return hex;
}

int StrSize(char *buf, int len, long long int size)
{
  static const char unit_char[] = "KMGTEPY";
  int remain;
  const char *unit;

  if(size < 1024){
    return snprintf(buf, len, "%dB", (int)size);
  }

  remain = size % 1024;
  size /= 1024;
  unit = unit_char;
  while(1024 < size && *unit){
    unit++;
    remain = size % 1024;
    size /= 1024;
  }
  size = size * 1024 + remain + 51;
  remain = size % 1024;
  size /= 1024;

  return snprintf(buf, len, "%lld.%d%cB", size, h2d(remain), *unit);
}

int StrDate(char *buf, int len, time_t *t)
{
  return strftime(buf, len, vOptions.dateFormat, localtime(t));
}

char *skipPsz(char *p, int n)
{
  int len;
  while(*p && n){
    len = strlen(p) + 1;
    p += len;
    n--;
  }
  return p;
}


int CfgOpenFile(const char *pszFile)
{
  DfStr path;
  int fd;
  int n;

  for(n = 0; n < 2; n++){
    switch(n){
    case 0:
      Str_InitStr(&path, getenv("HOME"));
      Str_Add(&path, "/.dfx/");
      break;
    case 1:
      Str_Add(&path, PREFIX "/dfx/");
      break;
    }
    Str_Add(&path, pszFile);
    fd = open(Str_Get(&path), O_RDONLY);
    if(fd != -1){
      break;
    }
    Str_SetLength(&path, 0);
  }

  Str_Free(&path, 0);
  return fd;

}

char *GetEncode(char *lang)
{
  char *e;
  char *at;

  e = lang;
  while(*e){
    if(*e == '.'){
      goto ENCODE;
    }
    e++;
  }
  return NULL;
ENCODE:
  at = e;
  while(*at){
    if(*at == '@'){
      *at = '\0';
      break;
    }
    at++;
  }
  return e;
}

static int inline fazzy_strncmp(const char *p, const char *q, int len)
{
  while(len){
    switch(*p){
    case ' ':
    case '-':
    case '_':
      break;
    default:
      if(tolower(*p) != tolower(*q)){
	return 1;
      }
      q++;
      break;
    }
    p++;
    len--;
  }
  return 0;
}

int InUTF8(void)
{
  char *lang;
  char *p;

  lang = getenv("LANG");
  if(lang == NULL){
    return 0;
  }

  p = FindChar(lang, '.');
  if(p == NULL || *p == '\0'){
    return 0;
  }
  lang = p + 1;
  p = FindChar(lang, '@');

  return !fazzy_strncmp(lang, "utf8", p - lang);
}


