#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "status.h"
#include "mem.h"
#include "xutil.h"
#include "misc.h"
#include "dfxfunc.h"
#include "dfval.h"

static int St_Free(void *list);
static int St_Active(Widget w, void *ptr);
static int St_Inactive(Widget w, void *ptr);
static int St_Draw(void *ptr, struct DfDrawInfo *di);

static const DfVerb St_Verb = {
  St_Free,
  St_Active,
  St_Inactive,
  BF_KeyPress,
  BF_ResizeNop,
  St_Draw,
};

static DfStatus *vST;

static int St_Free(void *ptr)
{
  DfStatus *st;

  st = ptr;

  Str_Free(&st->msg, 0);
  bFree(st);

  return 0;
}

static int St_Active(Widget w, void *ptr)
{
  return 0;
}

static int St_Inactive(Widget w, void *ptr)
{
  return 0;
}


static int St_Draw(void *ptr, struct DfDrawInfo *di)
{
  DfStatus *st;
  XRectangle *rc;

  st = (DfStatus*)ptr;
  rc = &st->b.rc;

  if(Str_Length(&st->msg) == 0){
    return 0;
  }

  XSetForeground(di->d, di->gc, vOptions.colors[COLOR_FILE]);
  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc,
		rc->x, rc->y + vnFontBase,
		Str_Get(&st->msg), Str_Length(&st->msg));
  return 0;
}

int MakeStatus(Widget w)
{
  DfStatus *st;
  int y;

  st = bMalloc(sizeof(*st));
  if(!st){
    return 1;
  }

  y = vnFontHeight;
  memset(st, 0, sizeof(*st));
  st->b.rc.x = 0;
  st->b.rc.y = dfx->height - y;
  st->b.rc.width = dfx->width;
  st->b.rc.height = y;
  st->b.v = &St_Verb;
  st->b.stat = BS_VISIBLE;
  st->b.type = DT_PROMPT;
  Str_Init(&st->msg);

  dfx->frame_bottom = dfx->height - y;

  AddBuffer(dfx->lists, GetBuffer(st));
  vST = st;

  return 0;
}

void St_SetMsg(Widget w, const char *msg)
{

  if(!msg){
    if(Str_Length(&vST->msg) == 0){
      return;
    }

    Str_SetLength(&vST->msg, 0);
    RedrawFrame(dfx->w, GetBuffer(vST), &vST->b.rc);
    return;
  }

  Str_Overwrite(&vST->msg, 0, msg);
  RedrawFrame(dfx->w, GetBuffer(vST), &vST->b.rc);
}

void St_PresetMsg(const char *msg)
{
  if(!msg){
    Str_SetLength(&vST->msg, 0);
    return;
  }
  Str_Overwrite(&vST->msg, 0, msg);
}

struct moveup_info{
  Widget w;
  GC gc;
  int cy;
};

static int enum_move_up(DfBuf *b, void *ptr)
{
  struct moveup_info *i = ptr;

  if(!IS_VISIBLE(b)){
    return 0;
  }
  if(b == GetBuffer(vST)){
    return 0;
  }
  if(!RectIsOverlap(&GetBuffer(vST)->rc, &b->rc)){
    return 0;
  }
      
  b->stat |= BS_PROMPTMARKED;
  if(b->rc.height < i->cy){
    b->stat &= ~BS_VISIBLE;
  }
  b->rc.height -= i->cy;
  if(b->v->resize){
    (*b->v->resize)(i->w, b);
  }
  DrawBorder(b, XtDisplay(i->w), i->w, i->gc);

  return 0;
}

void St_MoveUp(Widget w, int cy, int msg)
{
  struct moveup_info i;

  vST->b.rc.y -= cy;
  dfx->frame_bottom = vST->b.rc.y;

  i.cy = cy;
  i.gc = GetBufferGC(w, NULL);
  i.w = w;
  EnumBuffers(dfx->lists, enum_move_up, &i);

  if(msg < MSG_MAX){
    St_SetMsg(w, vOptions.msg[msg]);
  }else{
    InvalidateRect(w, &vST->b.rc);
  }
}

static int enum_move_down(DfBuf *b, void *ptr)
{
  int *y = ptr;

  if(b->stat & BS_PROMPTMARKED){
    b->stat &= ~BS_PROMPTMARKED;
    b->stat |= BS_VISIBLE;
    b->rc.height = *y - b->rc.y;
    if(b->v->resize){
      (*b->v->resize)(dfx->w, b);
    }
  }
  return 0;
}

void St_MoveDown(int cy)
{
  XRectangle rc;
  int y;

  rc = GetBuffer(vST)->rc;
  rc.y -= vOptions.borderWidth;
  rc.height += vOptions.borderWidth;
  InvalidateRect(dfx->w, &rc);

  vST->b.rc.y += cy;
  dfx->frame_bottom = vST->b.rc.y;

  y = vST->b.rc.y;
  EnumBuffers(dfx->lists, enum_move_down, &y);
}
