/* dialog operation */
typedef enum{
  DO_NONE,
  DO_COPY,
  DO_MOVE,
  DO_LINK,
  DO_SYMLINK,
  DO_RENAME,
  DO_DELETE,
  DO_CHMOD,
  DO_CHOWN,
  DO_CHGRP,
  DO_EXEC,
  DO_CHDIR,
  DO_MARK,
  DO_MKFILE,
  DO_MKDIR,
  DO_FILTER,
  DO_ISEARCH,
  DO_READDIR,
}df_opcode;

typedef enum{
  STATE_INIT,
  STATE_NONE,
  STATE_FAIL,
  STATE_COPYAS,
  STATE_ALREADYEXIST,
  STATE_DELETEONMOVEFAIL,
  STATE_CANCEL,
  CMD_OK,
  CMD_YES,
  CMD_NO,
  CMD_OVERWRITE,
  CMD_RETRY,
  CMD_SKIP,
  CMD_RENAME,
  CMD_CANCEL,
  CMD_ISEARCHNEXT,
  CMD_ISEARCHPREV,
  CMD_ISEARCHOPEN,
  CMD_ISEARCHPARENT,
}task_state;

typedef enum {
  TASK_FREE = 0,
  TASK_LEAVE
}task_result;


enum{
  DRQ_CALLBACK,
  DRQ_STMSG,
};

typedef struct dfsubdir_t DfSubDir;
#ifndef DFTASK
typedef struct dftask_t DfTask;
#define DFTASK
#endif

typedef struct dftask_vtable_t{
  task_result (*invoke)(DfTask *);
  task_result (*notify)(DfTask *);
  task_result (*done)(DfTask *);
  int (*init)(DfTask *);
  int (*procSelectedFiles)(DfTask *);
  int (*procSubDirectories)(DfTask *);
  int (*fileop)(DfTask *d, DfStr*, DfStr*, struct stat*);
  int (*predirwalk)(DfTask *d, DfStr*, DfStr *);
  int (*postdirwalk)(DfTask *d, DfStr*, DfStr *);
}task_vtable;

struct dftask_t{
  DfList link;
  DfList link_notify;
  DfBuf *owner;
  DfFileList *list;
  df_opcode op;
  task_state state;

  int flag;
  int break_flg;
  int err;
  int update;
  int init_msg_id;
  int msg_id;
  Widget w;
  DfStr input;/* must be release */
  DfStr cwd;/* current working directory. must be call Str_Free(X, 0). */
  DfStr dst;/* destination directory for copying/moving files. must be call Str_Free(X, 0). */
  DfStr cand;
  char *files;/* name of files. must be release. */
  char *now_proc;/* current file name */
  pthread_t t_info;
  DfSubDir *sub;
  void (*destroy)(DfTask *);
  void (*callback)(DfTask *);
  void *extend;
  const task_vtable *v;
};

struct dftask_chmod_info
{
  mode_t mode;
};

struct dftask_isearch_info
{
  Widget text;
};

/* flag */
#define DLGF_INPUT		(1)
#define DLGF_UPDATECWD		(1 << 1)
#define DLGF_UPDATEDST		(1 << 2)
#define DLGF_USESRC		(1 << 3)
#define DLGF_USEDST		(1 << 4)
#define DLGF_BOTHCWD		(1 << 5)
#define DLGF_LINK		(1 << 6)
#define DLGF_SUBDIR		(1 << 7)
#define DLGF_THREAD		(1 << 8)
#define DLGF_ALLOWDOTFILE	(1 << 9)

struct dfsubdir_t{
  DfTask *parent;
  DfSubDir *next;
  int mode;
  DfStr *src;
  DfStr *dst;
  int s_idx;
  int d_idx;
  DIR *dir;
  struct dirent *de;
};


typedef void (*dlg_request)(DfTask *t);

DfTask *MakeTask(Widget w, DfBuf *owner, df_opcode op, int msg_id, int ext_size);
void FreeTask(DfTask *d);
int OpCancelOperate(void);
void DlgSendEvent(DfTask *d, dlg_request rq);
int setupPathes(DfTask *d, DfStr *src, DfStr *dst, int bSlash);
DfSubDir *initSubDir(DfTask *d, const char *src, const char *dst);

int commonInit(DfTask *d);
task_result commonInvoke(DfTask *d);
task_result commonThreadedInvoke(DfTask *d);
task_result commonDone(DfTask *d);
int commonProcSelectedFile(DfTask *d);
int commonProcSubDirectories(DfTask *d);
task_result commonNotify(DfTask *d);
int PreDirDelete(DfTask *d, DfStr *src, DfStr *dst);
int PostDirDelete(DfTask *d, DfStr *src, DfStr *dst);

void DfxSendMsg(int msg, int err);
void taskCbInvoke(DfTask *t);
void taskCbNotify(DfTask *t);
void taskCbDone(DfTask *t);
void taskCbNone(DfTask *t);

extern DfList vDlgList;
extern DfList vNotifyTaskList;
extern pthread_mutex_t vMtxNotify;

extern task_vtable vtable_copy;
extern task_vtable vtable_move;
extern task_vtable vtable_delete;
extern task_vtable vtable_chmod;
extern task_vtable vtable_chown;
extern task_vtable vtable_chgrp;
extern task_vtable vtable_filter;
extern task_vtable vtable_ifilter;
extern task_vtable vtable_link;
extern task_vtable vtable_symlink;


